% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionSurv.R
\name{PredictionSurv}
\alias{PredictionSurv}
\title{Prediction Object for Survival}
\description{
This object stores the predictions returned by a learner of class \link{LearnerSurv}.

The \code{task_type} is set to \code{"surv"}.
}
\examples{
library(mlr3)
task = tsk("rats")
learner = lrn("surv.kaplan")
p = learner$train(task, row_ids = 1:20)$predict(task, row_ids = 21:30)
head(as.data.table(p))
}
\seealso{
Other Prediction: 
\code{\link{PredictionDens}}
}
\concept{Prediction}
\section{Super class}{
\code{\link[mlr3:Prediction]{mlr3::Prediction}} -> \code{PredictionSurv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{truth}}{(\code{Surv})\cr
True (observed) outcome.}

\item{\code{crank}}{(\code{numeric()})\cr
Access the stored predicted continuous ranking.}

\item{\code{distr}}{(\link[distr6:Matdist]{distr6::Matdist}|\link[distr6:VectorDistribution]{distr6::VectorDistribution})\cr
Convert the stored survival matrix to a survival distribution.}

\item{\code{lp}}{(\code{numeric()})\cr
Access the stored predicted linear predictor.}

\item{\code{response}}{(\code{numeric()})\cr
Access the stored predicted survival time.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PredictionSurv$new()}}
\item \href{#method-clone}{\code{PredictionSurv$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="filter">}\href{../../mlr3/html/Prediction.html#method-filter}{\code{mlr3::Prediction$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="format">}\href{../../mlr3/html/Prediction.html#method-format}{\code{mlr3::Prediction$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="help">}\href{../../mlr3/html/Prediction.html#method-help}{\code{mlr3::Prediction$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="print">}\href{../../mlr3/html/Prediction.html#method-print}{\code{mlr3::Prediction$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Prediction" data-id="score">}\href{../../mlr3/html/Prediction.html#method-score}{\code{mlr3::Prediction$score()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionSurv$new(
  task = NULL,
  row_ids = task$row_ids,
  truth = task$truth(),
  crank = NULL,
  distr = NULL,
  lp = NULL,
  response = NULL,
  check = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link{TaskSurv})\cr
Task, used to extract defaults for \code{row_ids} and \code{truth}.}

\item{\code{row_ids}}{(\code{integer()})\cr
Row ids of the predicted observations, i.e. the row ids of the test set.}

\item{\code{truth}}{(\code{survival::Surv()})\cr
True (observed) response.}

\item{\code{crank}}{(\code{numeric()})\cr
Numeric vector of predicted continuous rankings (or relative risks). One element for each
observation in the test set. For a pair of continuous ranks, a higher rank indicates that
the observation is more likely to experience the event.}

\item{\code{distr}}{(\verb{matrix()|[distr6::Matdist]|[distr6::VectorDistribution]})\cr
Either a matrix of predicted survival probabilities or a \link[distr6:VectorDistribution]{distr6::VectorDistribution}
or a \link[distr6:Matdist]{distr6::Matdist}.
If a matrix then column names must be given and correspond to survival times.
Rows of matrix correspond to individual predictions. It is advised that the
first column should be time \code{0} with all entries \code{1} and the last
with all entries \code{0}. If a \code{VectorDistribution} then each distribution in the vector
should correspond to a predicted survival distribution.}

\item{\code{lp}}{(\code{numeric()})\cr
Numeric vector of linear predictor scores. One element for each observation in the test
set. \eqn{lp = X\beta} where \eqn{X} is a matrix of covariates and \eqn{\beta} is a vector
of estimated coefficients.}

\item{\code{response}}{(\code{numeric()})\cr
Numeric vector of predicted survival times.
One element for each observation in the test set.}

\item{\code{check}}{(\code{logical(1)})\cr
If \code{TRUE}, performs argument checks and predict type conversions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictionSurv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
