% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrSVM.R
\name{mlr_learners_regr.svm}
\alias{mlr_learners_regr.svm}
\alias{LearnerRegrSVM}
\title{Support Vector Machine}
\description{
Support vector machine for regression.
Calls \code{\link[e1071:svm]{e1071::svm()}} from package \CRANpkg{e1071}.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("regr.svm")
lrn("regr.svm")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

, * Task type: \dQuote{regr}, * Predict Types: \dQuote{response}, * Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, * Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{e1071}
}

\section{Parameters}{

, |Id        |Type      |Default        |Levels                              |Range                                |, |:---------|:---------|:--------------|:-----------------------------------|:------------------------------------|, |cachesize |numeric   |40             |                                    |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |coef0     |numeric   |0              |                                    |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |cost      |numeric   |1              |                                    |\eqn{[0, \infty)}{[0, Inf)}          |, |cross     |integer   |0              |                                    |\eqn{[0, \infty)}{[0, Inf)}          |, |degree    |integer   |3              |                                    |\eqn{[1, \infty)}{[1, Inf)}          |, |epsilon   |numeric   |-              |                                    |\eqn{[0, \infty)}{[0, Inf)}          |, |fitted    |logical   |TRUE           |TRUE, FALSE                         |-                                    |, |gamma     |numeric   |-              |                                    |\eqn{[0, \infty)}{[0, Inf)}          |, |kernel    |character |radial         |linear, polynomial, radial, sigmoid |-                                    |, |nu        |numeric   |0.5            |                                    |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |scale     |untyped   |TRUE           |                                    |-                                    |, |shrinking |logical   |TRUE           |TRUE, FALSE                         |-                                    |, |tolerance |numeric   |0.001          |                                    |\eqn{[0, \infty)}{[0, Inf)}          |, |type      |character |eps-regression |eps-regression, nu-regression       |-                                    |
}

\examples{
if (requireNamespace("e1071", quietly = TRUE)) {
  learner = mlr3::lrn("regr.svm")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Cortes, Corinna, Vapnik, Vladimir (1995).
\dQuote{Support-vector networks.}
\emph{Machine Learning}, \bold{20}(3), 273--297.
\doi{10.1007/BF00994018}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrSVM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRegrSVM-new}{\code{LearnerRegrSVM$new()}}
\item \href{#method-LearnerRegrSVM-clone}{\code{LearnerRegrSVM$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrSVM-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrSVM-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrSVM$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrSVM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrSVM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrSVM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
