% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterMIM.R
\name{mlr_filters_mim}
\alias{mlr_filters_mim}
\alias{FilterMIM}
\title{Mutual Information Maximization Filter}
\description{
Conditional mutual information based feature selection filter
calling \code{\link[praznik:MIM]{praznik::MIM()}} in package \CRANpkg{praznik}.

This filter supports partial scoring (see \link{Filter}).
}
\details{
As the scores calculated by the \CRANpkg{praznik} package are not monotone due
to the greedy forward fashion, the returned scores simply reflect the selection order:
\code{1}, \code{(k-1)/k}, ..., \code{1/k} where \code{k} is the number of selected features.

Threading is disabled by default (hyperparameter \code{threads} is set to 1).
Set to a number \verb{>= 2} to enable threading, or to \code{0} for auto-detecting the number
of available cores.
}
\examples{
if (requireNamespace("praznik")) {
  task = mlr3::tsk("iris")
  filter = flt("mim")
  filter$calculate(task, nfeat = 2)
  as.data.table(filter)
}

if (mlr3misc::require_namespaces(c("mlr3pipelines", "rpart", "praznik"), quietly = TRUE)) {
  library("mlr3pipelines")
  task = mlr3::tsk("spam")

  # Note: `filter.frac` is selected randomly and should be tuned.

  graph = po("filter", filter = flt("mim"), filter.frac = 0.5) \%>>\%
    po("learner", mlr3::lrn("classif.rpart"))

  graph$train(task)
}
}
\references{
Kursa MB (2021).
\dQuote{Praznik: High performance information-based feature selection.}
\emph{SoftwareX}, \bold{16}, 100819.
\doi{10.1016/j.softx.2021.100819}.

For a benchmark of filter methods:

Bommert A, Sun X, Bischl B, Rahnenführer J, Lang M (2020).
\dQuote{Benchmark for filter methods for feature selection in high-dimensional classification data.}
\emph{Computational Statistics & Data Analysis}, \bold{143}, 106839.
\doi{10.1016/j.csda.2019.106839}.
}
\seealso{
\itemize{
\item \link[mlr3pipelines:mlr_pipeops_filter]{PipeOpFilter} for filter-based feature selection.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}
}

Other Filter: 
\code{\link{Filter}},
\code{\link{mlr_filters_anova}},
\code{\link{mlr_filters_auc}},
\code{\link{mlr_filters_carscore}},
\code{\link{mlr_filters_carsurvscore}},
\code{\link{mlr_filters_cmim}},
\code{\link{mlr_filters_correlation}},
\code{\link{mlr_filters_disr}},
\code{\link{mlr_filters_find_correlation}},
\code{\link{mlr_filters_importance}},
\code{\link{mlr_filters_information_gain}},
\code{\link{mlr_filters_jmim}},
\code{\link{mlr_filters_jmi}},
\code{\link{mlr_filters_kruskal_test}},
\code{\link{mlr_filters_mrmr}},
\code{\link{mlr_filters_njmim}},
\code{\link{mlr_filters_performance}},
\code{\link{mlr_filters_permutation}},
\code{\link{mlr_filters_relief}},
\code{\link{mlr_filters_selected_features}},
\code{\link{mlr_filters_variance}},
\code{\link{mlr_filters}}
}
\concept{Filter}
\section{Super class}{
\code{\link[mlr3filters:Filter]{mlr3filters::Filter}} -> \code{FilterMIM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FilterMIM-new}{\code{FilterMIM$new()}}
\item \href{#method-FilterMIM-clone}{\code{FilterMIM$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="calculate"><a href='../../mlr3filters/html/Filter.html#method-Filter-calculate'><code>mlr3filters::Filter$calculate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="format"><a href='../../mlr3filters/html/Filter.html#method-Filter-format'><code>mlr3filters::Filter$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="help"><a href='../../mlr3filters/html/Filter.html#method-Filter-help'><code>mlr3filters::Filter$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="print"><a href='../../mlr3filters/html/Filter.html#method-Filter-print'><code>mlr3filters::Filter$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterMIM-new"></a>}}
\if{latex}{\out{\hypertarget{method-FilterMIM-new}{}}}
\subsection{Method \code{new()}}{
Create a FilterMIM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterMIM$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterMIM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FilterMIM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterMIM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
