% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskGenerator.R
\name{TaskGenerator}
\alias{TaskGenerator}
\title{TaskGenerator Class}
\description{
Creates a \link{Task} of arbitrary size.
Predefined task generators are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_task_generators},
e.g. \code{\link[=mlr_task_generators_xor]{xor}}.
}
\seealso{
Other TaskGenerator: 
\code{\link{mlr_task_generators_2dnormals}},
\code{\link{mlr_task_generators_friedman1}},
\code{\link{mlr_task_generators_smiley}},
\code{\link{mlr_task_generators_xor}},
\code{\link{mlr_task_generators}}
}
\concept{TaskGenerator}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.
Used in tables, plot and text output.}

\item{\code{task_type}}{(\code{character(1)})\cr
Task type, e.g. \code{"classif"} or \code{"regr"}.

For a complete list of possible task types (depending on the loaded packages),
see \code{\link[=mlr_reflections]{mlr_reflections$task_types$type}}.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of hyperparameters.}

\item{\code{packages}}{(\code{character(1)})\cr
Set of required packages.
These packages are loaded, but not attached.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
Defaults to \code{NA}, but can be set by child classes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TaskGenerator$new()}}
\item \href{#method-generate}{\code{TaskGenerator$generate()}}
\item \href{#method-clone}{\code{TaskGenerator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGenerator$new(
  id,
  task_type,
  packages = character(),
  param_set = ParamSet$new(),
  man = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{task_type}}{(\code{character(1)})\cr
Type of task, e.g. \code{"regr"} or \code{"classif"}.
Must be an element of \link[=mlr_reflections]{mlr_reflections$task_types$type}.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled by the constructor if at least one of the packages is not installed,
but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of hyperparameters.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-generate"></a>}}
\if{latex}{\out{\hypertarget{method-generate}{}}}
\subsection{Method \code{generate()}}{
Creates a task of type \code{task_type} with \code{n} observations, possibly using additional settings stored in \code{param_set}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGenerator$generate(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of rows to generate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Task}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGenerator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
