% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSimple.R
\name{mlr_measures_classif.fbeta}
\alias{mlr_measures_classif.fbeta}
\title{F-beta Score}
\description{
Binary classification measure defined with \eqn{P} as \code{\link[mlr3measures:ppv]{precision()}} and \eqn{R} as
\code{\link[mlr3measures:tpr]{recall()}} as \deqn{
   (1 + \beta^2) \frac{P \cdot R}{(\beta^2 P) + R}.
}{
   (1 + beta^2) * (P*R) / ((beta^2 * P) + R).
}
It measures the effectiveness of retrieval with respect to a user who attaches \eqn{\beta}{beta} times
as much importance to recall as precision.
For \eqn{\beta = 1}{beta = 1}, this measure is called "F1" score.
}
\details{
This measure is undefined if
\itemize{
\item TP = 0
\item \link[mlr3measures]{precision} or \link[mlr3measures]{recall} is undefined, i.e. TP + FP = 0 or TP + FN = 0.
}
}
\note{
The score function calls \code{\link[mlr3measures:fbeta]{mlr3measures::fbeta()}} from package \CRANpkg{mlr3measures}.

If the measure is undefined for the input, \code{NaN} is returned.
This can be customized by setting the field \code{na_value}.
}
\section{Dictionary}{

This \link{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_measures} or with the associated sugar function \code{\link[=msr]{msr()}}:\preformatted{mlr_measures$get("classif.fbeta")
msr("classif.fbeta")
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Range \tab Levels \cr
   beta \tab integer \tab - \tab \eqn{[0, \infty)}{[0, Inf)} \tab - \cr
}
}

\section{Meta Information}{


\itemize{
\item Type: \code{"binary"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}

}

\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}

\code{as.data.table(mlr_measures)} for a complete table of all (also dynamically created) \link{Measure} implementations.

Other classification measures: 
\code{\link{mlr_measures_classif.acc}},
\code{\link{mlr_measures_classif.auc}},
\code{\link{mlr_measures_classif.bacc}},
\code{\link{mlr_measures_classif.bbrier}},
\code{\link{mlr_measures_classif.ce}},
\code{\link{mlr_measures_classif.costs}},
\code{\link{mlr_measures_classif.dor}},
\code{\link{mlr_measures_classif.fdr}},
\code{\link{mlr_measures_classif.fnr}},
\code{\link{mlr_measures_classif.fn}},
\code{\link{mlr_measures_classif.fomr}},
\code{\link{mlr_measures_classif.fpr}},
\code{\link{mlr_measures_classif.fp}},
\code{\link{mlr_measures_classif.logloss}},
\code{\link{mlr_measures_classif.mbrier}},
\code{\link{mlr_measures_classif.mcc}},
\code{\link{mlr_measures_classif.npv}},
\code{\link{mlr_measures_classif.ppv}},
\code{\link{mlr_measures_classif.prauc}},
\code{\link{mlr_measures_classif.precision}},
\code{\link{mlr_measures_classif.recall}},
\code{\link{mlr_measures_classif.sensitivity}},
\code{\link{mlr_measures_classif.specificity}},
\code{\link{mlr_measures_classif.tnr}},
\code{\link{mlr_measures_classif.tn}},
\code{\link{mlr_measures_classif.tpr}},
\code{\link{mlr_measures_classif.tp}}

Other binary classification measures: 
\code{\link{mlr_measures_classif.auc}},
\code{\link{mlr_measures_classif.bbrier}},
\code{\link{mlr_measures_classif.dor}},
\code{\link{mlr_measures_classif.fdr}},
\code{\link{mlr_measures_classif.fnr}},
\code{\link{mlr_measures_classif.fn}},
\code{\link{mlr_measures_classif.fomr}},
\code{\link{mlr_measures_classif.fpr}},
\code{\link{mlr_measures_classif.fp}},
\code{\link{mlr_measures_classif.mcc}},
\code{\link{mlr_measures_classif.npv}},
\code{\link{mlr_measures_classif.ppv}},
\code{\link{mlr_measures_classif.prauc}},
\code{\link{mlr_measures_classif.precision}},
\code{\link{mlr_measures_classif.recall}},
\code{\link{mlr_measures_classif.sensitivity}},
\code{\link{mlr_measures_classif.specificity}},
\code{\link{mlr_measures_classif.tnr}},
\code{\link{mlr_measures_classif.tn}},
\code{\link{mlr_measures_classif.tpr}},
\code{\link{mlr_measures_classif.tp}}
}
\concept{binary classification measures}
\concept{classification measures}
