% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generateThreshVsPerf.R
\name{generateThreshVsPerfData}
\alias{generateThreshVsPerfData}
\title{Generate threshold vs. performance(s) for 2-class classification.}
\usage{
generateThreshVsPerfData(obj, measures, gridsize = 100L, task.id = NULL)
}
\arguments{
\item{obj}{[(list of) \code{\link{Prediction}} | (list of) \code{\link{ResampleResult}} | \code{\link{BenchmarkResult}}]\cr
Single prediction object, list of them, single resample result, list of them, or a benchmark result.
In case of a list probably produced by different learners you want to compare, then
name the list with the names you want to see in the plots, probably
learner shortnames or ids.}

\item{measures}{[\code{\link{Measure}} | list of \code{\link{Measure}}]\cr
Performance measure(s) to evaluate.}

\item{gridsize}{[\code{integer(1)}]\cr
Grid resolution for x-axis (threshold).
Default is 100.}

\item{task.id}{[\code{character(1)}]\cr
Selected task in \code{\link{BenchmarkResult}} to do plots for, ignored otherwise.
Default is first task.}
}
\description{
Generate threshold vs. performance(s) for 2-class classification.
}
\seealso{
Other generate_plot_data: \code{\link{generateFilterValuesData}};
  \code{\link{generateLearningCurveData}};
  \code{\link{generateROCRCurvesData}};
  \code{\link{getFilterValues}}

Other thresh_vs_perf: \code{\link{plotThreshVsPerfGGVIS}};
  \code{\link{plotThreshVsPerf}}
}

