% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/benchmark.R
\name{benchmark}
\alias{benchmark}
\title{Benchmark experiment for multiple learners and tasks.}
\usage{
benchmark(learners, tasks, resamplings, measures, keep.pred = TRUE,
  show.info = getMlrOption("show.info"))
}
\arguments{
\item{learners}{[(list of) \code{\link{Learner}}]\cr
Learning algorithms which should be compared.}

\item{tasks}{[(list of) \code{\link{Task}}]\cr
Tasks that learners should be run on.}

\item{resamplings}{[(list of) \code{\link{ResampleDesc}} | \code{\link{ResampleInstance}}]\cr
Resampling strategy for each tasks.
If only one is provided, it will be replicated to match the number of tasks.
If missing, a 10-fold cross validation is used.}

\item{measures}{[(list of) \code{\link{Measure}}]\cr
Performance measures for all tasks.
If missing, the default measure of the first task is used.}

\item{keep.pred}{[\code{logical(1)}]\cr
Keep the prediction data in the \code{pred} slot of the result object.
If you do many experiments (on larger data sets) these objects might unnecessarily increase
object size / mem usage, if you do not really need them.
In this case you can this argument to \code{FALSE}.
Default is \code{TRUE}.}

\item{show.info}{[\code{logical(1)}]\cr
Print verbose output on console?
Default is set via \code{\link{configureMlr}}.}
}
\value{
[\code{\link{BenchmarkResult}}].
}
\description{
Complete benchmark experiment to compare different learning algorithms across one or more tasks
w.r.t. a given resampling strategy. Experiments are paired, meaning always the same
training / test sets are used for the different learners.
Furthermore, you can of course pass \dQuote{enhanced} learners via wrappers, e.g., a
learner can be automatically tuned using \code{\link{makeTuneWrapper}}.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}};
  \code{\link{getBMRAggrPerformances}};
  \code{\link{getBMRFeatSelResults}};
  \code{\link{getBMRFilteredFeatures}};
  \code{\link{getBMRLearnerIds}};
  \code{\link{getBMRPerformances}};
  \code{\link{getBMRPredictions}};
  \code{\link{getBMRTaskIds}};
  \code{\link{getBMRTuneResults}}
}

