% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateLearningCurve.R
\name{plotLearningCurve}
\alias{plotLearningCurve}
\title{Plot learning curve data using ggplot2.}
\usage{
plotLearningCurve(obj, facet = "measure", pretty.names = TRUE,
  facet.wrap.nrow = NULL, facet.wrap.ncol = NULL)
}
\arguments{
\item{obj}{(\link{LearningCurveData})\cr
Result of \link{generateLearningCurveData}, with class \code{LearningCurveData}.}

\item{facet}{(\code{character(1)})\cr
Selects \dQuote{measure} or \dQuote{learner} to be the facetting variable.
The variable mapped to \code{facet} must have more than one unique value, otherwise it will
be ignored. The variable not chosen is mapped to color if it has more than one unique value.
The default is \dQuote{measure}.}

\item{pretty.names}{(\code{logical(1)})\cr
Whether to use the \link{Measure} name instead of the id in the plot.
Default is \code{TRUE}.}

\item{facet.wrap.nrow, facet.wrap.ncol}{(\link{integer})\cr
Number of rows and columns for facetting. Default for both is \code{NULL}.
In this case ggplot's \code{facet_wrap} will choose the layout itself.}
}
\value{
ggplot2 plot object.
}
\description{
Visualizes data size (percentage used for model) vs. performance measure(s).
}
\seealso{
Other learning_curve: \code{\link{generateLearningCurveData}}

Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}}, \code{\link{plotResiduals}},
  \code{\link{plotThreshVsPerf}}
}
