% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeOverBaggingWrapper}
\alias{makeOverBaggingWrapper}
\title{Fuse learner with the bagging technique and oversampling for imbalancy correction.}
\usage{
makeOverBaggingWrapper(learner, obw.iters = 10L, obw.rate = 1,
  obw.maxcl = "boot")
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{obw.iters}{[\code{integer(1)}]\cr
Number of fitted models in bagging.
Default is 10.}

\item{obw.rate}{[\code{numeric(1)}]\cr
Factor to upsample the smaller class in each bag.
Must be between 1 and \code{Inf},
where 1 means no oversampling and 2 would mean doubling the class size.
Default is 1.}

\item{obw.maxcl}{[\code{character(1)}]\cr
character value that controls how to sample majority class.
\dQuote{all} means every instance of the majority class gets in each bag,
\dQuote{boot} means the majority class instances are bootstrapped in each iteration.
Default is \dQuote{boot}.}
}
\value{
[\code{\link{Learner}}].
}
\description{
Fuses a classification learner for binary classification with an over-bagging method
for imbalancy correction when we have strongly unequal class sizes.
Creates a learner object, which can be
used like any other learner object.
Models can easily be accessed via \code{\link{getBaggingModels}}.

OverBagging is implemented as follows:
For each iteration a random data subset is sampled. Minority class examples
are oversampled with replacement with a given rate.
Majority class examples are either simply copied into each bag, or bootstrapped with replacement
until we have as many majority class examples as in the original training data.
Features are currently not changed or sampled.

Prediction works as follows:
For classification we do majority voting to create a discrete label and
probabilities are predicted by considering the proportions of all predicted labels.
}
\seealso{
Other imbalancy: \code{\link{makeOversampleWrapper}},
  \code{\link{makeUndersampleWrapper}};
  \code{\link{oversample}}, \code{\link{undersample}};
  \code{\link{smote}}
}

