% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{mlflow_load_model}
\alias{mlflow_load_model}
\title{Load MLflow Model}
\usage{
mlflow_load_model(model_uri, flavor = NULL, client = mlflow_client())
}
\arguments{
\item{model_uri}{The location, in URI format, of the MLflow model.}

\item{flavor}{Optional flavor specification (string). Can be used to load a particular flavor in
case there are multiple flavors available.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Loads an MLflow model. MLflow models can have multiple model flavors. Not all flavors / models
can be loaded in R. This method by default searches for a flavor supported by R/MLflow.
}
\details{
The URI scheme must be supported by MLflow - i.e. there has to be an MLflow artifact
         repository corresponding to the scheme of the URI. The content is expected to point to a
         directory containing MLmodel. The following are examples of valid model uris:

                 - ``file:///absolute/path/to/local/model``
                 - ``file:relative/path/to/local/model``
                 - ``s3://my_bucket/path/to/model``
                 - ``runs:/<mlflow_run_id>/run-relative/path/to/model``

 For more information about supported URI schemes, see the Artifacts Documentation at
 https://www.mlflow.org/docs/latest/tracking.html#supported-artifact-stores.
}
