% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project-run.R
\name{mlflow_run}
\alias{mlflow_run}
\title{Run in MLflow}
\usage{
mlflow_run(entry_point = NULL, uri = ".", version = NULL,
  param_list = NULL, experiment_id = NULL, experiment_name = NULL,
  mode = NULL, cluster_spec = NULL, git_username = NULL,
  git_password = NULL, no_conda = FALSE, storage_dir = NULL)
}
\arguments{
\item{entry_point}{Entry point within project, defaults to `main` if not specified.}

\item{uri}{A directory containing modeling scripts, defaults to the current directory.}

\item{version}{Version of the project to run, as a Git commit reference for Git projects.}

\item{param_list}{A list of parameters.}

\item{experiment_id}{ID of the experiment under which to launch the run.}

\item{experiment_name}{Name of the experiment under which to launch the run.}

\item{mode}{Execution mode to use for run.}

\item{cluster_spec}{Path to JSON file describing the cluster to use when launching a run on Databricks.}

\item{git_username}{Username for HTTP(S) Git authentication.}

\item{git_password}{Password for HTTP(S) Git authentication.}

\item{no_conda}{If specified, assume that MLflow is running within a Conda environment with the necessary
dependencies for the current project instead of attempting to create a new Conda environment. Only
valid if running locally.}

\item{storage_dir}{Valid only when `mode` is local. MLflow downloads artifacts from distributed URIs passed to
parameters of type `path` to subdirectories of `storage_dir`.}
}
\value{
The run associated with this run.
}
\description{
Wrapper for `mlflow run`.
}
