% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmetrics_av.R
\name{Averaged metrics}
\alias{Averaged metrics}
\alias{accuracy}
\alias{precision}
\alias{micro_precision}
\alias{macro_precision}
\alias{recall}
\alias{micro_recall}
\alias{macro_recall}
\alias{fmeasure}
\alias{micro_fmeasure}
\alias{macro_fmeasure}
\title{Multi-label averaged evaluation metrics}
\usage{
accuracy(true_labels, predicted_labels, undefined_value = "diagnose")

precision(true_labels, predicted_labels, undefined_value = "diagnose")

micro_precision(true_labels, predicted_labels, ...)

macro_precision(true_labels, predicted_labels,
  undefined_value = "diagnose")

recall(true_labels, predicted_labels, undefined_value = "diagnose")

micro_recall(true_labels, predicted_labels, ...)

macro_recall(true_labels, predicted_labels, undefined_value = "diagnose")

fmeasure(true_labels, predicted_labels, undefined_value = "diagnose")

micro_fmeasure(true_labels, predicted_labels, ...)

macro_fmeasure(true_labels, predicted_labels,
  undefined_value = "diagnose")
}
\arguments{
\item{true_labels}{Matrix of true labels, columns corresponding to labels and
rows to instances.}

\item{predicted_labels}{Matrix of predicted labels, columns corresponding to
labels and rows to instances.}

\item{undefined_value}{The value to be returned when a computation results in
an undefined value due to a division by zero. See details.}

\item{...}{Additional parameters for precision, recall and Fmeasure.}
}
\value{
Atomical numeric vector containing the resulting value in the range
 [0, 1].
}
\description{
Evaluation metrics based on simple metrics for the confusion
 matrix, averaged through several criteria.
}
\details{
\strong{Available metrics in this category}
\itemize{
 \item \code{accuracy}: Bipartition based accuracy
 \item \code{fmeasure}:  Example and binary partition F_1 measure (harmonic mean between precision and recall, averaged by instance)
 \item \code{macro_fmeasure}: Label and bipartition based F_1 measure (harmonic mean between precision and recall, macro-averaged by label)
 \item \code{macro_precision}: Label and bipartition based precision (macro-averaged by label)
 \item \code{macro_recall}: Label and bipartition based recall (macro-averaged by label)
 \item \code{micro_fmeasure}: Label and bipartition based F_1 measure (micro-averaged)
 \item \code{micro_precision}: Label and bipartition based precision (micro-averaged)
 \item \code{micro_recall}: Label and bipartition based recall (micro-averaged)
 \item \code{precision}: Example and bipartition based precision (averaged by instance)
 \item \code{recall}: Example and bipartition based recall (averaged by instance)
 }

\strong{Deciding a value when denominators are zero}

Parameter \code{undefined_value}: The value to be returned when a computation
results in an undefined value due to a division by zero. Can be a single
value (e.g. NA, 0), a function with the following signature:

\code{function(tp, fp, tn, fn)}

or a string corresponding to one of the predefined strategies. These are:
\itemize{
 \item \code{"diagnose"}: This strategy performs the following decision:
 \itemize{
  \item Returns 1 if there are no true labels and none were predicted
  \item Returns 0 otherwise
 }
 This is the default strategy, and the one followed by MULAN.
 \item \code{"ignore"}: Occurrences of undefined values will be ignored when
 averaging (averages will be computed with potentially less values than
 instances/labels). Undefined values in micro-averaged metrics cannot be
 ignored (will return \code{NA}).
 \item \code{"na"}: Will return \code{NA} (with class \code{numeric}) and it
 will be propagated when averaging (averaged metrics will potentially return
 \code{NA}).
}
}
\examples{
true_labels <- matrix(c(
1,1,1,
0,0,0,
1,0,0,
1,1,1,
0,0,0,
1,0,0
), ncol = 3, byrow = TRUE)
predicted_labels <- matrix(c(
1,1,1,
0,0,0,
1,0,0,
1,1,0,
1,0,0,
0,1,0
), ncol = 3, byrow = TRUE)

precision(true_labels, predicted_labels, undefined_value = "diagnose")
macro_recall(true_labels, predicted_labels, undefined_value = 0)
macro_fmeasure(
  true_labels, predicted_labels,
  undefined_value = function(tp, fp, tn, fn) as.numeric(fp == 0 && fn == 0)
)
}
\seealso{
\code{\link{mldr_evaluate}}, \code{\link{mldr_to_labels}}

Other evaluation metrics: \code{\link{Basic metrics}},
  \code{\link{Ranking-based metrics}}
}
\concept{evaluation metrics}
