% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_gids.R
\name{make_gids}
\alias{make_gids}
\title{Create game ids from dates.}
\usage{
make_gids(start = NULL, end = NULL, league = "mlb", dataset = NULL,
  game_ids = NULL, ...)
}
\arguments{
\item{start}{A start date passed as a character in ISO 8601 format. \code{"2017-05-01"}}

\item{end}{An end date passed as a character in ISO 8601 format. \code{"2017-09-01"}}

\item{league}{The league to gather gids for. The default is \code{"mlb"}. Other options include \code{"aaa"} and \code{"aa"}.}

\item{dataset}{The dataset to be scraped. The default is "inning_all." Other options include, "inning_hit", "linescore."}

\item{game_ids}{A list of user-supplied gameIds.}

\item{...}{additional arguments}
}
\description{
Create game ids from dates.
}
\examples{

gids <- make_gids(start = "2016-06-01", end = "2016-06-01", dataset="inning_all")


}
\keyword{internal}
