% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{endpoints}
\alias{endpoints}
\title{Function to calculate endpoints for further use from kinetic models fitted
with mkinfit}
\usage{
endpoints(fit, covariates = NULL, covariate_quantile = 0.5)
}
\arguments{
\item{fit}{An object of class \link{mkinfit}, \link{nlme.mmkin} or \link{saem.mmkin}, or
another object that has list components mkinmod containing an \link{mkinmod}
degradation model, and two numeric vectors, bparms.optim and bparms.fixed,
that contain parameter values for that model.}

\item{covariates}{Numeric vector with covariate values for all variables in
any covariate models in the object. If given, it overrides 'covariate_quantile'.}

\item{covariate_quantile}{This argument only has an effect if the fitted
object has covariate models. If so, the default is to show endpoints
for the median of the covariate values (50th percentile).}
}
\value{
A list with a matrix of dissipation times named distimes, and, if
applicable, a vector of formation fractions named ff and, if the SFORB model
was in use, a vector of eigenvalues of these SFORB models, equivalent to
DFOP rate constants
}
\description{
This function calculates DT50 and DT90 values as well as formation fractions
from kinetic models fitted with mkinfit. If the SFORB model was specified
for one of the parents or metabolites, the Eigenvalues are returned. These
are equivalent to the rate constants of the DFOP model, but with the
advantage that the SFORB model can also be used for metabolites.
}
\details{
Additional DT50 values are calculated from the FOMC DT90 and k1 and k2 from
HS and DFOP, as well as from Eigenvalues b1 and b2 of any SFORB models
}
\note{
The function is used internally by \link{summary.mkinfit},
\link{summary.nlme.mmkin} and \link{summary.saem.mmkin}.
}
\examples{

  fit <- mkinfit("FOMC", FOCUS_2006_C, quiet = TRUE)
  endpoints(fit)
  \dontrun{
    fit_2 <- mkinfit("DFOP", FOCUS_2006_C, quiet = TRUE)
    endpoints(fit_2)
    fit_3 <- mkinfit("SFORB", FOCUS_2006_C, quiet = TRUE)
    endpoints(fit_3)
  }

}
\author{
Johannes Ranke
}
