% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setExtMort.R
\name{setExtMort}
\alias{setExtMort}
\alias{getExtMort}
\alias{ext_mort}
\alias{ext_mort<-}
\title{Set external mortality rate}
\usage{
setExtMort(
  params,
  ext_mort = NULL,
  z0pre = 0.6,
  z0exp = -1/4,
  reset = FALSE,
  z0 = deprecated(),
  ...
)

getExtMort(params)

ext_mort(params)

ext_mort(params) <- value
}
\arguments{
\item{params}{MizerParams}

\item{ext_mort}{Optional. An array (species x size) holding the external
mortality rate.  If not supplied, a default is set as described in the
section "Setting external mortality rate".}

\item{z0pre}{If \code{z0}, the mortality from other sources, is not a column
in the species data frame, it is calculated as z0pre * w_max ^ z0exp.
Default value is 0.6.}

\item{z0exp}{If \code{z0}, the mortality from other sources, is not a column in
the species data frame, it is calculated as \code{z0pre * w_max ^ z0exp}.
Default value is \code{n-1}.}

\item{reset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
If set to TRUE, then the external mortality rate will be reset
to the value calculated from the \code{z0} parameters, even if it was
previously overwritten with a custom value. If set to FALSE (default) then
a recalculation from the species parameters will take place only if no
custom value has been set.}

\item{z0}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{ext_mort} instead. Not to
be confused with the species_parameter \code{z0}.}

\item{...}{Unused}

\item{value}{ext_mort}
}
\value{
\code{setExtMort()}: A MizerParams object with updated external mortality
rate.

\code{getExtMort()} or equivalently \code{ext_mort()}: An array (species x
size) with the external mortality.
}
\description{
Set external mortality rate
}
\section{Setting external mortality rate}{

The external mortality is all the mortality that is not due to fishing or
predation by predators included in the model. The external mortality could be
due to predation by predators that are not explicitly included in the model
(e.g. mammals or seabirds) or due to other causes like illness. It is a rate
with units 1/year.

The \code{ext_mort} argument allows you to specify an external mortality rate
that depends on species and body size. You can see an example of this in
the Examples section of the help page for \code{\link[=setExtMort]{setExtMort()}}.

If the \code{ext_mort} argument is not supplied, then the external mortality is
assumed to depend only on the species, not on the size of the individual:
\eqn{\mu_{ext.i}(w) = z_{0.i}}. The value of the constant \eqn{z_0} for each
species is taken from the \code{z0} column of the species parameter data frame, if
that column exists. Otherwise it is calculated as
\deqn{z_{0.i} = {\tt z0pre}_i\, w_{inf}^{\tt z0exp}.}{z_{0.i} = z0pre_i w_{inf}^{z0exp}.}
}

\examples{
params <- newMultispeciesParams(NS_species_params)

#### Setting allometric death rate #######################

# Set coefficient for each species. Here we choose 0.1 for each species
z0pre <- rep(0.1, nrow(species_params(params)))

# Multiply by power of size with exponent, here chosen to be -1/4
# The outer() function makes it an array species x size
allo_mort <- outer(z0pre, w(params)^(-1/4))

# Change the external mortality rate in the params object
ext_mort(params) <- allo_mort
}
\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
