% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerEGrowth}
\alias{mizerEGrowth}
\title{Get energy rate available for growth needed to project standard mizer model}
\usage{
mizerEGrowth(params, n, n_pp, n_other, e_repro, e, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{e_repro}{The energy available for reproduction (optional, although if
specified, e must also be specified). A matrix of size no. species x no.
size bins. If not supplied, is calculated internally using
\code{\link[=getERepro]{getERepro()}}.}

\item{e}{The energy available for reproduction and growth (optional, although
if specified, e_repro must also be specified). A matrix of size no.
species x no. size bins. If not supplied, is calculated internally using
\code{\link[=getEReproAndGrowth]{getEReproAndGrowth()}}.}

\item{...}{Optional arguments for rate functions.}
}
\value{
A two dimensional array (species x size) with the growth rates.
}
\description{
Calculates the energy rate \eqn{g_i(w)} (grams/year) available by species and
size for growth after metabolism, movement and reproduction have been
accounted for. Used by \code{\link[=project]{project()}} for performing simulations.
}
\seealso{
Other mizer rate functions: 
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
