% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_metrics.R
\name{metrics.covlmc}
\alias{metrics.covlmc}
\alias{print.metrics.covlmc}
\title{Predictive quality metrics for VLMC with covariates}
\usage{
\method{metrics}{covlmc}(model, ...)

\method{print}{metrics.covlmc}(x, ...)
}
\arguments{
\item{model}{The context based model on which to compute predictive metrics.}

\item{...}{Additional parameters for predictive metrics computation.}

\item{x}{A metrics.covlmc object, results of a call to \code{\link[=metrics.covlmc]{metrics.covlmc()}}}
}
\value{
An object of class \code{metrics.covlmc} with the following components:
\itemize{
\item \code{accuracy}: the accuracy of the predictions
\item \code{conf_mat}: the confusion matrix of the predictions, with predicted values
in rows and true values in columns
\item \code{auc}: the AUC of the predictive model
}

The object has a print method that recalls basic information about the model
together with the values of the components above.
}
\description{
This function computes and returns predictive quality metrics for context
based models such as VLMC and VLMC with covariates.
}
\details{
A context based model computes transition probabilities for its contexts.
Using a maximum transition probability decision rule, this can be used to
predict the new state that is the more likely to follow the current one,
given the context (see \code{\link[=predict.vlmc]{predict.vlmc()}}). The quality of these predictions is
evaluated using standard metrics including:
\itemize{
\item accuracy
\item the full confusion matrix
\item the area under the roc curve (AUC), considering the context based model as
a (conditional) probability estimator. We use Hand and Till (2001) multiclass
AUC in case of a state space with more than 2 states
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(metrics.covlmc)}: Prints the predictive metrics of the VLMC model with covariates.

}}
\section{Extended contexts}{


As explained in details in \code{\link[=loglikelihood.covlmc]{loglikelihood.covlmc()}} documentation and in
the dedicated \code{vignette("likelihood", package = "mixvlmc")}, the first
initial values of a time series do not in general have a proper context for
a COVLMC with a non zero order. In order to predict something meaningful
for those values, we rely on the notion of extended context defined in the
documents mentioned above. This follows the same logic as using
\code{\link[=loglikelihood.covlmc]{loglikelihood.covlmc()}} with the parameter \code{initial="extended"}. All
covlmc functions that need to manipulate initial values with no proper
context use the same approach.
}

\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
breaks <- c(
  0,
  median(powerconsumption$active_power, na.rm = TRUE),
  max(powerconsumption$active_power, na.rm = TRUE)
)
labels <- c(0, 1)
dts <- cut(pc$active_power, breaks = breaks, labels = labels)
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 5)
metrics(m_cov)

}
\references{
David J. Hand and Robert J. Till (2001). "A Simple Generalisation
of the Area Under the ROC Curve for Multiple Class Classification Problems."
\emph{Machine Learning} 45(2), p. 171--186. DOI: \doi{10.1023/A:1010920819831}.
}
\seealso{
\code{\link[=metrics.vlmc]{metrics.vlmc()}}, \code{\link[=metrics.ctx_node]{metrics.ctx_node()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}}, \code{\link[=predict.vlmc]{predict.vlmc()}}.
}
