% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_contexts.R
\name{context_number.covlmc}
\alias{context_number.covlmc}
\title{Contexts number of a VLMC with covariates}
\usage{
\method{context_number}{covlmc}(ct)
}
\arguments{
\item{ct}{a fitted covlmc model.}
}
\value{
the number of contexts present in the VLMC with covariates.
}
\description{
This function returns the total number of contexts of a VLMC with covariates.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
m_cov <- covlmc(dts, dts_cov, min_size = 10)
# should be 3
context_number(m_cov)
}
