% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc_simulate.R
\name{simulate.vlmc}
\alias{simulate.vlmc}
\title{Simulate a discrete time series for a vlmc}
\usage{
\method{simulate}{vlmc}(object, nsim = 1, seed = NULL, init = NULL, ...)
}
\arguments{
\item{object}{a fitted vlmc object.}

\item{nsim}{length of the simulated time series (defaults to 1).}

\item{seed}{an optional random seed.}

\item{init}{an optional initial sequence for the time series}

\item{...}{additional arguments.}
}
\value{
a simulated discrete time series of the same type as the one used to build the vlmc.
}
\description{
This function simulates a time series from the distribution estimated by the
given vlmc object.
}
\details{
The time series can be initiated by a fixed sequence specified via the \code{init}
parameter.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts, min_size = 5)
new_dts <- simulate(model, 500, seed = 0)
new_dts_2 <- simulate(model, 500, seed = 0, init = dts[1:5])
}
