% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc.R
\name{prune}
\alias{prune}
\alias{prune.vlmc}
\title{Prune a Variable Length Markov Chain (VLMC)}
\usage{
prune(vlmc, alpha = 0.05, cutoff = NULL, ...)

\method{prune}{vlmc}(vlmc, alpha = 0.05, cutoff = NULL, ...)
}
\arguments{
\item{vlmc}{a fitted VLMC model.}

\item{alpha}{number in (0,1] (default: 0.05) cut off value in quantile scale
for pruning.}

\item{cutoff}{positive number: cut off value in native (log likelihood ratio)
scale for pruning. Defaults to the value obtained from \code{alpha}. Takes
precedence over \code{alpha} if specified.}

\item{...}{additional arguments for the prune function.}
}
\value{
a pruned VLMC
}
\description{
This function prunes a VLMC.
}
\details{
In general, pruning a VLMC is more efficient than constructing two VLMC (the
base one and pruned one). Up to numerical instabilities, building a VLMC with
a \code{a} cut off and then pruning it with a \code{b} cut off (with \code{a>b}) should
produce the same VLMC than building directly the VLMC with a \code{b} cut off.
Interesting cut off values can be extracted from a VLMC using the \code{\link[=cutoff]{cutoff()}}
function.

As automated model selection is provided by \code{\link[=tune_vlmc]{tune_vlmc()}}, the direct use of \code{cutoff}
should be reserved to advanced exploration of the set of trees that can be
obtained from a complex one, e.g. to implement model selection techniques that
are not provided by \code{\link[=tune_vlmc]{tune_vlmc()}}.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
base_model <- vlmc(dts, alpha = 0.1)
model_cuts <- cutoff(base_model)
pruned_model <- prune(base_model, model_cuts[3])
draw(pruned_model)
direct_simple <- vlmc(dts, alpha = model_cuts[3])
draw(direct_simple)
# pruned_model and direct_simple should be identical
all.equal(pruned_model, direct_simple)
}
\seealso{
\code{\link[=cutoff]{cutoff()}} and \code{\link[=tune_vlmc]{tune_vlmc()}}
}
