% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contexts.R
\name{contexts}
\alias{contexts}
\title{Contexts of a context tree}
\usage{
contexts(ct, type = c("auto", "list", "data.frame"), reverse = TRUE, ...)
}
\arguments{
\item{ct}{a context tree.}

\item{type}{result type (see details).}

\item{reverse}{logical (defaults to FALSE). See details.}

\item{...}{additional arguments for the contexts function.}
}
\value{
The list of the contexts represented in this tree or a data.frame
with more content.
}
\description{
This function extracts from a context tree a description of all of its
contexts.
}
\details{
The default behavior consists in returning a list of all the contexts
contained in the tree (with \code{type="auto"} or \code{type="list"}). When
\code{type="data.frame"}, the method returns a data.frame whose first column,
named \code{context}, contains the contexts. Other columns contain context
specific values which depend on the actual class of the tree and on
additional parameters. An adapted return type is chosen when type="auto"`.
}
\section{State order in a context}{
 Notice that contexts are given by default
in the "reverse" order used by the VLMC papers: older values are on the
right. For instance, the context \code{c(0, 1)} is reported if the sequence 1,
then 0 appeared in the time series used to build the context tree. Set
reverse to \code{FALSE} for the reverse convention.
}

\examples{
dts <- sample(as.factor(c("A", "B", "C")), 100, replace = TRUE)
dts_tree <- ctx_tree(dts, max_depth = 3, min_size = 5)
contexts(dts_tree)
contexts(dts_tree, "data.frame", TRUE)
}
\seealso{
\code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}}, \code{\link[=contexts.vlmc]{contexts.vlmc()}}, \code{\link[=contexts.covlmc]{contexts.covlmc()}}.
}
