\name{qqMix}
\alias{qqMix}
\title{
Draw a normal quantile-quantile plot of the residuals from
a fitted mixture of linear regressions.
}
\description{
Draws a normal quantile-quantile plot using symbols whose sizes are
proportional to the probabilities that the associated observations
were generated by the associated components of the model.
}
\usage{
qqMix(object, xlim=NULL, ylim=NULL,
      shape=c("disc","lozenge","square","none"), ngon=20, size=1, \dots)
}
\arguments{
\item{object}{
An object of class \code{"mixresid"}, which consists of
a list with entries providing the residuals, the relevant
probabilities, the predictors, and the observations, as returned
by \code{residuals.mixreg()}.  When plotting against fitted values,
it is probably better to used the standardized residuals,
i.e. \code{residuals.mixreg()} should be called with \code{std=TRUE}.
}
\item{xlim}{
A numeric vector of length two, giving
the limits on the \eqn{x}-axis.  Has the usual default.
}
\item{ylim}{
A numeric vector of length two, giving
the limits on the \eqn{y}-axis.  Has the usual default.
}
\item{shape}{
The shape of the plotting symbol.  May be abbreviated to the first
letter, i.e. \code{"d"}, \code{"l"}, \code{"s"}, or \code{"n"}.
If \code{shape} is \code{"none"} then \dQuote{ordinary} plotting is
done, using the usual plotting symbols etc.  This can be much faster,
but somewhat defeats the purpose of this plotting function in that
the resulting plots can be misleading.  Using \code{shape="n"}
allows the user to compare the misleading result with plots in
which \dQuote{improbable} residuals are downweighted,
}
\item{ngon}{
The "disc" shape is actually a regular polygon; ngon specifies
how many sides it should have; ignored if shape is not equal
to "disc".
}
\item{size}{
A scale factor to change the absolute sizes of the plotting
symbols; values larger than 1 make the symbols larger than
the default; values less than 1 make them smaller.
}
\item{...}{
Additional arguments to be passed to the polygon function which
actually draws the plotting symbols.
}
}
\value{
None.  This function is called for its side effect of drawing
a normal quantile-quantile plot.
}
\details{
The plot produced is visually assessed by ignoring or discounting
small symbols.
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\references{
T. Rolf Turner (2000). Estimating the rate of spread of a
viral infection of potato plants via mixtures of regressions.
\emph{Applied Statistics} \bold{49} Part 3, pp. 371 -- 384.
}
\section{ACKNOWLEDGEMENT}{
The idea of creating residual plots for regression mixtures by
making the symbol size proportional to the associated probability
is due to Prof. Adrian Baddeley who was, at the time (2000)
at the University of Western Australia. He is now (2021) at Curtin
University.
}
\seealso{
\code{\link{ncMcTest}()},\code{\link{cband}()}, \code{\link{covMix}()},
\code{\link{mixreg}()}, \code{\link{plot.cband}()},
\code{\link{plot.mixresid}()}, \code{\link{qqMix}()},
\code{\link{residuals.mixreg}()}
}
\examples{
# Aphids.
    fita <- mixreg(plntsInf~aphRel,ncomp=2,seed=42,data=aphids)
    resa <- residuals(fita,std=TRUE)
    qqMix(resa,size=2,shape="l")
    qqMix(resa,shape="n",pch=7,cex=1.5)
# Kilns.
    thStrt <- list(list(beta=c(26.1,48800),sigsq=0.58,lambda=0.33333333),
                   list(beta=c(23.5,32400),sigsq=0.58,lambda=0.33333333),
                   list(beta=c(-0.06,20760),sigsq=0.58,lambda=0.33333333))
    fitk   <- mixreg(y ~ x,ncomp=3,data=kilnAoneOut,thetaStart=thStrt)
    \dontrun{ # Takes too long
        resk   <- residuals(fitk,std=TRUE)
        qqMix(resk,shape="s")
        qqMix(resk,shape="s",xlim=c(-0.25,0.9),ylim=c(-3,3))
        qqMix(resk,shape="n")
    }
}
\keyword{models}
\keyword{regression}
\keyword{hplot}
