% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.as.R
\name{na.as}
\alias{na.as}
\title{Replace Missing Values With User-Specified Values}
\usage{
na.as(x, value, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a vector, factor, matrix or data frame.}

\item{value}{a numeric value or character string with which \code{NA} is
replaced.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns \code{x} with \code{NA} replaced with the numeric value or character
string specified in \code{value}.
}
\description{
This function replaces \code{NA} in a vector, factor, matrix or data frame with
user-specified values in the argument \code{value}.
}
\examples{
#--------------------------------------
# Numeric vector
x.num <- c(1, 3, NA, 4, 5)

# Replace NA with 2
na.as(x.num, value = 2)

#--------------------------------------
# Character vector
x.chr <- c("a", NA, "c", "d", "e")

# Replace NA with "b"
na.as(x.chr, value = "b")

#--------------------------------------
# Factor
x.factor <- factor(c("a", "a", NA, NA, "c", "c"))

# Replace NA with "b"
na.as(x.factor, value = "b")

#--------------------------------------
# Matrix
x.mat <- matrix(c(1, NA, 3, 4, 5, 6), ncol = 2)

# Replace NA with 2
na.as(x.mat, value = 2)

#--------------------------------------
# Data frame
x.df1 <- data.frame(x1 = c(NA, 2, 3),
                    x2 = c(2, NA, 3),
                    x3 = c(3, NA, 2), stringsAsFactors = FALSE)

# Replace NA with -99
na.as(x.df1, value = -99)

#--------------------------------------
# Recode value in data frame
x.df2 <- data.frame(x1 = c(1, 2, 30),
                    x2 = c(2, 1, 30),
                    x3 = c(30, 1, 2))

# Replace 30 with NA and then replace NA with 3
na.as(x.df2, value = 3, as.na = 30)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}

\code{\link{as.na}}, \code{\link{na.auxiliary}}, \code{\link{na.coverage}},
\code{\link{na.descript}}, \code{\link{na.indicator}}, \code{\link{na.pattern}},
\code{\link{na.prop}}, \code{\link{na.test}}
}
