% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-operations.R
\name{gintervals.mark_overlaps}
\alias{gintervals.mark_overlaps}
\title{Mark overlapping intervals with a group ID}
\usage{
gintervals.mark_overlaps(
  intervals,
  group_col = "overlap_group",
  unify_touching_intervals = TRUE
)
}
\arguments{
\item{intervals}{intervals set}

\item{group_col}{name of the column to store the overlap group IDs (default: "overlap_group")}

\item{unify_touching_intervals}{if 'TRUE', touching one-dimensional
intervals are unified}
}
\value{
The intervals set with an additional column containing group IDs
from gintervals.canonic mapping. All overlapping intervals will have the same group ID.
}
\description{
Mark overlapping intervals with a group ID
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
# Create sample overlapping intervals
intervs <- data.frame(
    chrom = "chr1",
    start = c(11000, 100, 10000, 10500),
    end = c(12000, 200, 13000, 10600),
    data = c(10, 20, 30, 40)
)

# Mark overlapping intervals
intervs_marked <- gintervals.mark_overlaps(intervs)

# Use custom column name
intervs_marked <- gintervals.mark_overlaps(intervs, group_col = "my_groups")
}
