% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.conf.cor.R
\name{print.conf.cor}
\alias{print.conf.cor}
\title{Print cor.conf}
\usage{
\method{print}{conf.cor}(x, ...)
}
\arguments{
\item{x}{\code{cor.conf} object.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{cor.conf} object
}
\examples{
#--------------------------------------
# Two-sided 95\% Confidence Interval
# r = 0.55, n = 120

obj <- conf.cor(r = 0.55, n = 120, output = FALSE)
print(obj)

#--------------------------------------
# One-sided 99\% Confidence Interval

# Generate random data
dat <- sim.cor(100, rho = 0.4)

obj <- conf.cor(dat$x, dat$y, conf.level = 0.99, alternative = "less",
               output = FALSE)
print(obj)
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
New York: John Wiley & Sons.

Kubinger, K. D., Rasch, D., & Simeckova, M. (2007). Testing a correlation coefficient's significance:
Using H0: 0 \eqn{< \rho \le \lambda} is preferable to H0: \eqn{\rho = }0. \emph{Psychology Science, 49}, 74-87.
}
\seealso{
\code{\link{conf.cor}}
}

