% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/00-classes.R
\docType{class}
\name{MixedClass-class}
\alias{MixedClass-class}
\title{Class "MixedClass"}
\description{
Defines the object returned from \code{\link{mixedmirt}}.
}
\section{Slots}{


 \describe{
   \item{\code{Data}:}{Object of class \code{"list"}, contains various data matricies and properties }
   \item{\code{iter}:}{Object of class \code{"numeric"}, number of iterations  }
   \item{\code{pars}:}{Object of class \code{"list"}, estimated parameter objects list }
   \item{\code{shortpars}:}{Object of class \code{"numeric"}, unique estimated parameters}
   \item{\code{model}:}{Object of class \code{"list"}, list containing original model }
   \item{\code{K}:}{Object of class \code{"numeric", number of item categories}  }
   \item{\code{itemloc}:}{Object of class \code{"numeric", index for tabdata}  }
   \item{\code{df}:}{Object of class \code{"numeric"}, degrees of freedom}
   \item{\code{AIC}:}{Object of class \code{"numeric"}, Akaike's information criteria }
   \item{\code{BIC}:}{Object of class \code{"numeric"}, Bayesian information criteria }
   \item{\code{G2}:}{Object of class \code{"numeric"}, G squared stat }
   \item{\code{p}:}{Object of class \code{"numeric"}, p-value for G2  }
   \item{\code{df}:}{Object of class \code{"numeric"}, degrees of freedom }
   \item{\code{RMSEA}:}{Object of class \code{"numeric"}, root mean-square error of approximation for G2}
   \item{\code{TLI}:}{Object of class \code{"numeric"}, Tucker-Lewis index for G2}
   \item{\code{CFI}:}{Object of class \code{"numeric"}, CFI for G2}
   \item{\code{logLik}:}{Object of class \code{"numeric"}, observed log-likelihood }
   \item{\code{SElogLik}:}{Object of class \code{"numeric"}, Monte Carlo standard error for log-likelihood }
   \item{\code{F}:}{Object of class \code{"matrix"}, unrotated factor loadings }
   \item{\code{h2}:}{Object of class \code{"numeric"}, commonalities }
   \item{\code{Theta}:}{Object of class \code{"matrix"}, ability grid }
   \item{\code{Pl}:}{Object of class \code{"numeric"}, normed likelihoods for tabulated response}
   \item{\code{prodlist}:}{Object of class \code{"list"}, list containing product combination of factors }
   \item{\code{converge}:}{Object of class \code{"numeric"}, convergence diagnostic }
   \item{\code{quadpts}:}{Object of class \code{"numeric"}, number of quadrature points }
   \item{\code{esttype}:}{Object of class \code{"character"}, indicates whether estimation was 'EM' or 'MHRM'}
   \item{\code{cand.t.var}:}{Object of class \code{"numeric"}, parameter used to control the MH sampler for Theta}
   \item{\code{random}:}{Object of class \code{"list"}, typicall null, except for internal mixed model usage}
   \item{\code{null.mod}:}{Object of class \code{"SingleGroupClass"}, null model}
   \item{\code{condnum}:}{Object of class \code{"numeric"}, condition number of information matrix}
   \item{\code{secondordertest}:}{Object of class \code{"logical"}, indicate whether information matrix passes
      second-order test}
    \item{\code{infomethod}:}{Object of class \code{"character"}, indiciates which information estimation method was used}
    \item{\code{TOL}:}{Object of class \code{"numeric"}, tollerence stopping criteria}
    \item{\code{CUSTOM.IND}:}{Object of class \code{"integer"}, an internal index}
    \item{\code{SLOW.IND}:}{Object of class \code{"integer"}, an internal index}
    \item{\code{formulas}:}{Object of class \code{"list"}, list of formula}
    \item{\code{covdata}:}{Object of class \code{"data.frame"}, covariate data}
    \item{\code{itemdesign}:}{Object of class \code{"data.frame"}, item design data}
   \item{\code{Call}:}{Object of class \code{"call"}, call }
 }
}

\section{Methods}{


 \describe{
   \item{coef}{\code{signature(object = "MixedClass")}}
   \item{print}{\code{signature(x = "MixedClass")} }
   \item{residuals}{\code{signature(object = "MixedClass")}}
   \item{show}{\code{signature(object = "MixedClass")} }
   \item{summary}{\code{signature(object = "MixedClass")} }
   \item{logLik}{\code{signature(object = "MixedClass")} }
   \item{anova}{\code{signature(object = "MixedClass")} }
  }
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{classes}

