\name{itemplot}
\alias{itemplot}
\title{Displays item surface and information plots}
\usage{
itemplot(object, item, type = "trace", degrees = 45, CE = FALSE,
  CEalpha = 0.05, CEdraws = 1000, drop.zeros = FALSE, rot = list(xaxis =
  -70, yaxis = 30, zaxis = 10), theta_lim = c(-4, 4), shiny = FALSE, ...)
}
\arguments{
  \item{object}{a computed model object of class
  \code{ExploratoryClass}, \code{ConfirmatoryClass}, or
  \code{MultipleGroupClass}. Input may also be a
  \code{list} for comparing similar item types (e.g., 1PL
  vs 2PL)}

  \item{item}{a single numeric value, or the item name,
  indicating which item to plot}

  \item{type}{plot type to use, information
  (\code{'info'}), standard errors (\code{'SE'}), item
  trace lines (\code{'trace'}), information and standard
  errors (\code{'infoSE'}) or information and trace lines
  (\code{'infotrace'}), relative efficiency lines
  (\code{'RE'}), expected score \code{'score'}, or
  information and trace line contours (\code{'infocontour'}
  and \code{'tracecontour'}; not supported for
  \code{MultipleGroupClass} objects)}

  \item{degrees}{the degrees argument to be used if there
  are exactly two factors. See \code{\link{iteminfo}} for
  more detail}

  \item{CE}{logical; plot confidence envelope?}

  \item{CEalpha}{area remaining in the tail for confidence
  envelope. Default gives 95\% confidence region}

  \item{CEdraws}{draws number of draws to use for
  confidence envelope}

  \item{rot}{a list of rotation coordinates to be used for
  3 dimensional plots}

  \item{drop.zeros}{logical; drop slope values that are
  numerically close to zero to reduce dimensionality?
  Useful in objects returned from \code{\link{bfactor}} or
  other confirmatory models that contain several zero
  slopes}

  \item{theta_lim}{lower and upper limits of the latent
  trait (theta) to be evaluated, and is used in conjunction
  with \code{npts}}

  \item{shiny}{logical; run interactive display for item
  plots using the \code{shiny} interface.  This primarily
  is an instructive tool for demonstrating how item
  response curves behave when adjusting their parameters}

  \item{...}{additional arguments to be passed to
  \code{lattice} and \code{coef()}}
}
\description{
\code{itemplot} displays various item based IRT plots, with
special options for plotting items that contain several 0
slope parameters. Supports up to three dimensional models.
}
\examples{
\dontrun{

data(LSAT7)
fulldata <- expand.table(LSAT7)
mod1 <- mirt(fulldata,1,SE=TRUE)
mod2 <- mirt(fulldata,1, itemtype = 'Rasch')
mod3 <- mirt(fulldata,2)

itemplot(mod1, 2)
itemplot(mod1, 2, CE = TRUE)
itemplot(mod1, 2, type = 'info')
itemplot(mod1, 2, type = 'info', CE = TRUE)

mods <- list(twoPL = mod1, onePL = mod2)
itemplot(mods, 1, type = 'RE')

#multidimensional
itemplot(mod3, 3, type = 'info')
itemplot(mod3, 3, type = 'infocontour')
itemplot(mod3, 3, type = 'tracecontour')

#polytomous items
pmod <- mirt(Science, 1, SE=TRUE)
itemplot(pmod, 3)
itemplot(pmod, 3, CE = TRUE)
itemplot(pmod, 3, type = 'score')
itemplot(pmod, 3, type = 'infotrace')

#interactive shiny applet
itemplot(shiny = TRUE)
    }
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{plot}

