% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLCI.mirt.R
\name{PLCI.mirt}
\alias{PLCI.mirt}
\title{Compute profiled-likelihood (or posterior) confidence intervals}
\usage{
PLCI.mirt(mod, parnum = NULL, alpha = 0.05, search_bound = TRUE,
  step = 0.5, lower = TRUE, upper = TRUE, inf2val = 30,
  NealeMiller = FALSE, ...)
}
\arguments{
\item{mod}{a converged mirt model}

\item{parnum}{a numeric vector indicating which parameters to estimate.
Use \code{\link{mod2values}} to determine parameter numbers. If \code{NULL}, all possible
parameters are used}

\item{alpha}{two-tailed alpha critical level}

\item{search_bound}{logical; use a fixed grid of values around the ML estimate to
determine more suitable optimization bounds? Using this has much better behaviour
than setting fixed upper/lower bound values and searching from more extreme ends}

\item{step}{magnitude of steps used when \code{search_bound} is \code{TRUE}.
Smaller values create more points to search a suitable bound for (up to the
lower bound value visible with \code{\link{mod2values}}). When upper/lower bounds are detected
this value will be adjusted accordingly}

\item{lower}{logical; search for the lower CI?}

\item{upper}{logical; search for the upper CI?}

\item{inf2val}{a numeric used to change parameter bounds which are infinity to a finite number.
Decreasing this too much may not allow a suitable bound to be located. Default is 30}

\item{NealeMiller}{logical; use the Neale and Miller 1997 approximation? Default is \code{FALSE}}

\item{...}{additional arguments to pass to the estimation functions}
}
\description{
Computes profiled-likelihood based confidence intervals. Supports the inclusion of
equality constraints. Object returns the confidence intervals
and whether the respective interval could be found.
}
\examples{

\dontrun{
mirtCluster() #use all available cores to estimate CI's in parallel
dat <- expand.table(LSAT7)
mod <- mirt(dat, 1)

result <- PLCI.mirt(mod)
result

# model with constraints
mod <- mirt(dat, 'F = 1-5
                  CONSTRAIN = (1-5, a1)')

result <- PLCI.mirt(mod)
result

mod2 <- mirt(Science, 1)
result2 <- PLCI.mirt(mod2)
result2

#only estimate CI's slopes
sv <- mod2values(mod2)
parnum <- sv$parnum[sv$name == 'a1']
result3 <- PLCI.mirt(mod2, parnum)
result3

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\references{
Neale, M. C. & Miller, M. B. (1997). The use of likelihood-based confidence intervals in genetic
models. Behavior Genetircs, 27, 113-120
}
\seealso{
\code{\link{boot.mirt}}
}
\keyword{likelihood}
\keyword{profiled}

