context('mirtOne')

test_that('dich', {
    data <- expand.table(LSAT7)
    mod1 <- mirt(data, 1, verbose=FALSE)
    expect_is(mod1, 'SingleGroupClass')
    expect_equal(extract.mirt(mod1, 'df'), 21)
    cfs <- as.numeric(do.call(c, coef(mod1, digits = 4)))
    expect_equal(cfs, c(0.988, 1.8561, 0, 1, 1.081, 0.808, 0, 1, 1.706, 1.8043, 0, 1, 0.7651, 0.486, 0, 1, 0.7358, 1.8545, 0, 1, 0, 1),
                 tolerance = 1e-2)
    sv <- mod2values(mod1)
    sv$est <- FALSE
    moddummy <- mirt(data, 1, pars= sv, verbose=FALSE)
    expect_is(moddummy, 'SingleGroupClass')
    sv2 <- mod2values(moddummy)
    expect_equal(sv$value, sv2$value)
    modm1 <- mirt(data, 1, SE = TRUE, SE.type = 'SEM', verbose=FALSE)
    expect_true(extract.mirt(modm1, 'SEMconv'))
    cfs <- as.numeric(do.call(c, coef(modm1, digits = 4)))
    expect_equal(extract.mirt(modm1, 'condnum'), 30.134809, tolerance = 1e-4)
    expect_equal(cfs, c(0.9876, 0.6367, 1.3384, 1.8559, 1.5978, 2.1139, 0, NA, NA, 1, NA, NA, 1.0808, 0.7604, 1.4013, 0.808, 0.6335, 0.9825, 0, NA, NA, 1, NA, NA, 1.7075, 1.0868, 2.3281, 1.8052, 1.4028, 2.2076, 0, NA, NA, 1, NA, NA, 0.765, 0.5065, 1.0235, 0.486, 0.3114, 0.6606, 0, NA, NA, 1, NA, NA, 0.7357, 0.4246, 1.0467, 1.8545, 1.6332, 2.0757, 0, NA, NA, 1, NA, NA, 0, NA, NA, 1, NA, NA),
                 tolerance = 1e-2)
    expect_is(modm1, 'SingleGroupClass')
    modm2 <- mirt(data, 1, SE = TRUE, SE.type = 'Richardson', verbose=FALSE)
    cfs <- as.numeric(do.call(c, coef(modm2, digits=4)))
    expect_equal(extract.mirt(modm2, 'condnum'), 30.24068, tolerance = 1e-3)
    expect_equal(cfs, c(0.988, 0.6406, 1.3354, 1.8561, 1.5984, 2.1138, 0, NA, NA, 1, NA, NA, 1.081, 0.7501, 1.4119, 0.808, 0.6291, 0.9869, 0, NA, NA, 1, NA, NA, 1.706, 1.0779, 2.334, 1.8043, 1.4036, 2.205, 0, NA, NA, 1, NA, NA, 0.7651, 0.5022, 1.028, 0.486, 0.3392, 0.6328, 0, NA, NA, 1, NA, NA, 0.7358, 0.4395, 1.032, 1.8545, 1.6302, 2.0787, 0, NA, NA, 1, NA, NA, 0, NA, NA, 1, NA, NA),
                 tolerance = 1e-2)
    expect_is(modm2, 'SingleGroupClass')
    modm3 <- mirt(data, 1, itemtype = 'Rasch', verbose=FALSE, SE=TRUE)
    expect_is(modm3, 'SingleGroupClass')
    expect_equal(extract.mirt(modm3, 'df'), 25)
    expect_equal(extract.mirt(modm3, 'condnum'), 4.741137, tolerance = 1e-4)
    LG <- lagrange(modm3, parnum = list(1, 5))
    expect_equal(LG$X2, c(0.46730208, 0.05686589), tolerance = 1e-4)
    dat <- expand.table(LSAT6)
    modm3 <- mirt(dat, 1, itemtype = 'Rasch', SE = TRUE, SE.type = 'SEM', verbose=FALSE)
    expect_is(modm3, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modm3)))
    expect_equal(cfs, c(1,NA,NA,2.73,2.455,3.005,0,NA,NA,1,NA,NA,1,NA,NA,0.999,0.827,1.17,0,NA,NA,1,NA,NA,1,NA,NA,0.24,0.096,0.384,0,NA,NA,1,NA,NA,1,NA,NA,1.306,1.12,1.493,0,NA,NA,1,NA,NA,1,NA,NA,2.099,1.873,2.326,0,NA,NA,1,NA,NA,0,NA,NA,0.57,0.339,0.802),
                 tolerance = 1e-2)
    model <- mirt.model('F = 1-5
                        CONSTRAIN = (1-5, a1)', quiet=TRUE)
    modm4 <- mirt(data, model, verbose = FALSE, SE=T, SE.type = 'crossprod')
    expect_equal(extract.mirt(modm4, 'condnum'), 5.171716, tolerance = 1e-4)
    cfs <- as.numeric(do.call(c, coef(modm4)))
    expect_equal(cfs, c(1.011, 0.885, 1.138, 1.868, 1.67, 2.067, 0, NA, NA, 1, NA, NA, 1.011, 0.885, 1.138, 0.791, 0.631, 0.951, 0, NA, NA, 1, NA, NA, 1.011, 0.885, 1.138, 1.461, 1.277, 1.644, 0, NA, NA, 1, NA, NA, 1.011, 0.885, 1.138, 0.521, 0.367, 0.676, 0, NA, NA, 1, NA, NA, 1.011, 0.885, 1.138, 1.993, 1.793, 2.193, 0, NA, NA, 1, NA, NA, 0, NA, NA, 1, NA, NA),
                 tolerance = 1e-2)
    svalues <- mirt(data, 1, pars = 'values', verbose=FALSE)
    svalues[22, 'value'] <- 2
    modm5 <- mirt(data, 1, pars = svalues, verbose=FALSE)
    expect_is(modm5, 'SingleGroupClass')
    expect_message(modm7 <- mirt(data, 1, '4PL', verbose=FALSE, parprior = list(c(3,7,11,15,19,'norm', -1.7, .1),
                                                                 c(4,8,12,16,20,'norm', 1.7, .1))),
                   "EM cycles terminated after 500 iterations.")
    expect_equal(extract.mirt(modm7, 'df'), 11)
    expect_is(modm7, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modm7)))
    expect_equal(cfs, c(5.231,8.739,0.154,0.858,5.584,3.505,0.16,0.843,11.193,11.951,0.155,0.862,1.285,0.854,0.153,0.845,4.697,9.029,0.154,0.859,0,1), tolerance = 1e-2)
    data[1,1] <- data[2,2] <- NA
    modm6 <- mirt(data, 1, verbose=FALSE)
    expect_equal(modm6@Fit$df, 21)
    expect_is(modm6, 'SingleGroupClass')
    cfs <- as.numeric(do.call(c, coef(modm6)))
    expect_equal(cfs, c(0.969, 1.851, 0, 1, 1.074, 0.808, 0, 1, 1.717, 1.811, 0, 1, 0.763, 0.486, 0, 1, 0.731, 1.852, 0, 1, 0, 1), tolerance = 1e-2)
    modideal <- mirt(data, 1, verbose=FALSE, itemtype='ideal')
    cfs <- as.numeric(do.call(c, coef(modideal)))
    expect_equal(cfs, c(0.288, -0.568, 0.422, -0.891, 0.57, -0.564, 0.292, -1, 0.207, -0.559, 0, 1), tolerance = 1e-2)

    #QMCEM
    mod <- mirt(dat, 1, method = 'QMCEM', verbose=FALSE, optimizer='NR')
    expect_equal(extract.mirt(mod, 'logLik'), -2466.653, tolerance=1e-4)
    fs <- fscores(mod, QMC=TRUE, verbose=FALSE, full.scores=FALSE)
    expect_equal(fs[1:3,'F1'], c(-1.8971, -1.4750, -1.4547), tolerance=1e-4)
    m2 <- M2(mod, QMC=TRUE)
    expect_equal(m2$M2, 4.737918, tolerance=1e-5)
    ifit <- itemfit(mod, QMC=TRUE, digits = 20)
    expect_equal(ifit$p.S_X2[1], .7985, tolerance = 1e-2)

    fm1 <- fscores(modm1, verbose = FALSE, full.scores=FALSE)
    expect_is(fm1, 'matrix')
    expect_true(mirt:::closeEnough(fm1[1:6,'F1'] - c(-1.8665957, -1.5266920, -1.5134024,
                                                     -1.1852276, -1.0946830, -0.7666992), -1e-2, 1e-2))
    fm2 <- fscores(modm2, method = 'MAP', verbose = FALSE, full.scores=FALSE)
    expect_is(fm2, 'matrix')
    expect_true(mirt:::closeEnough(fm2[1:6,'F1'] - c(-1.8165552, -1.4946906, -1.4822982,
                                                     -1.1789899, -1.0958928, -0.7951026), -1e-2, 1e-2))
    fm3 <- fscores(modm4, method = 'ML', full.scores = TRUE, verbose = FALSE)
    expect_is(fm3, 'matrix')
    expect_true(fm3[1, 'F1'] == -Inf && fm3[1000, 'F1'] == Inf)
    expect_true(mirt:::closeEnough(as.numeric(fm3[c(13,34,40),'F1'])
                                   - c(-2.783489, -1.750890, -2.783489), -1e-2, 1e-2))
    fm3 <- fscores(modm3, method = 'ML', full.scores = TRUE, verbose = FALSE, scores.only=TRUE)
    expect_is(fm3, 'matrix')
    fm4 <- fscores(modm6, method = 'ML', full.scores = TRUE, verbose = FALSE)
    expect_is(fm4, 'matrix')
    fm5 <- fscores(modm6, method = 'ML', full.scores = FALSE, verbose = FALSE)
    expect_is(fm5, 'matrix')
    fm6 <- fscores(modm1, method = 'EAPsum', full.scores = FALSE, verbose = FALSE)
    expect_is(fm6, 'data.frame')
    expect_true(mirt:::closeEnough(as.numeric(as.matrix(fm6)) - c(0, 1, 2, 3, 4, 5, -1.86979064140452, -1.43186046328808, -0.948846194779857, -0.413196324822194, 0.151728912219935, 0.727187920356908, 0.692703044748005, 0.683869406240695, 0.694229464900551, 0.72109478232691, 0.75877178915917, 0.800933349649957, 12, 40, 114, 205, 321, 308, 10.0899688084156, 44.6588676724085, 109.773048269864, 207.73908599116, 319.185336256462, 308.55369300169), -1e-2, 1e-2))
    expect_equal(as.numeric(attr(fm6, 'fit')['rxx_Theta.1']), 0.4319948, tolerance = 1e-4)

    res1 <- residuals(modm1, verbose = FALSE)
    expect_equal(as.numeric(res1), c(NA, -0.45, -0.855, 2.58, 2.396, -0.021, NA, 1.055, -0.265, -1.381, -0.029, 0.032, NA, -0.154, -0.003, 0.051, -0.016, -0.012, NA, 0, 0.049, -0.037, -0.002, 0, NA),
                 tolerance = 1e-2)
    res2 <- residuals(modm2, verbose = FALSE)
    expect_is(res1, 'matrix')
    expect_is(res2, 'matrix')
    IP1 <- itemplot(modm1, 1)
    IP2 <- itemplot(modm2, 1)
    expect_is(IP1, 'trellis')
    expect_is(IP2, 'trellis')
    TP1 <- plot(modm1)
    TP2 <- plot(modm2)
    expect_is(TP1, 'trellis')
    expect_is(TP2, 'trellis')
    ifit <- itemfit(modm1, X2 = TRUE, digits = 20)
    expect_is(ifit, 'data.frame')
    expect_true(mirt:::closeEnough(as.numeric(ifit$Zh) - c(1.431838, 6.354917, 5.310844, 5.804449,
                                                           0.696139), -1e-2, 1e-2))
    expect_true(mirt:::closeEnough(as.numeric(ifit$X2) - c(91.71819, 390.07985, 145.39978, 329.48529, 129.49679), -1e-2, 1e-2))
    expect_true(mirt:::closeEnough(as.numeric(ifit$S_X2) - c(4.749440, 14.451071,  1.270381,
                                                             5.237400,  0.941125), -1e-2, 1e-2))
    expect_true(mirt:::closeEnough(as.numeric(ifit$df) - c(8,8,8,8,8), -1e-4, 1e-4))
    expect_true(mirt:::closeEnough(as.numeric(ifit$df.S_X2) - c(2,2,2,2,2), -1e-4, 1e-4))

    fitm1 <- M2(modm1)
    expect_is(fitm1, 'data.frame')
    expect_true(mirt:::closeEnough(fitm1$M2 - 11.93841, -1e-2, 1e-2))
    expect_true(mirt:::closeEnough(fitm1$df.M2 - 5, -1e-4, 1e-4))
    fitm2 <- M2(modm3)
    expect_is(fitm2, 'data.frame')
    expect_true(mirt:::closeEnough(fitm2$M2 - 4.821999, -1e-4, 1e-4))
    expect_true(mirt:::closeEnough(fitm2$df.M2 - 9, -1e-4, 1e-4))

    data <- expand.table(LSAT7)
    model <- 'F1 = 1-3
              F2 = 3-5'
    modm1 <- mirt(data, model, verbose=FALSE)
    expect_equal(extract.mirt(modm1, 'df'), 20)
    modm2 <- mirt(data, model, itemtype=c('2PL','2PL', 'PC2PL','2PL', '2PL'), TOL=1e-3, verbose=FALSE)
    cfs <- as.numeric(do.call(c, coef(modm2, digits = 4)))
    expect_equal(cfs, c(0.6514, 0, 1.7031, 0, 1, 1.4872, 0, 0.9174, 0, 1, 2.5151, 3.4949, 3.1337, 5.2577, 0, 1, 0, 0.7058, 0.4789, 0, 1, 0, 0.8524, 1.9092, 0, 1, 0, 0, 1, 0, 1),
                 tolerance = 1e-2)
    expect_equal(extract.mirt(modm2, 'df'), 19)
    modm3 <- mirt(data, model, SE = TRUE, verbose=FALSE)
    expect_is(modm3, 'SingleGroupClass')

    fm1 <- fscores(modm1, verbose = FALSE, full.scores=FALSE)
    expect_is(fm1, 'matrix')
    fm2 <- fscores(modm3, method = 'MAP', verbose = FALSE)
    expect_is(fm2, 'matrix')
})

