% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promises.R
\name{as.promise.mirai}
\alias{as.promise.mirai}
\title{Make Mirai Promise}
\usage{
\method{as.promise}{mirai}(x)
}
\arguments{
\item{x}{an object of class \sQuote{mirai}.}
}
\value{
A \sQuote{promise} object.
}
\description{
Creates a \sQuote{promise} from a \sQuote{mirai}.
}
\details{
This function is an S3 method for the generic \code{as.promise} for class
\sQuote{mirai}.

Requires the \CRANpkg{promises} package.

Allows a \sQuote{mirai} to be used with the promise pipe \code{\%...>\%},
which schedules a function to run upon resolution of the \sQuote{mirai}.
}
\examples{
if (interactive() && requireNamespace("promises", quietly = TRUE)) {

library(promises)

p <- as.promise(mirai("example"))
print(p)
is.promise(p)

p2 <- mirai("completed") \%...>\% identity()
p2$then(cat)
is.promise(p2)

}

}
