library(mirai)
nanotest <- function(x) invisible(x || stop())
nanotestn <- function(x) invisible(is.null(x) || stop())
nanotestz <- function(x) invisible(x == 0L || stop())
nanotesto <- function(x) invisible(x == 1L || stop())
nanotestp <- function(x) invisible(is.character(capture.output(print(x))) || stop())
nanotesterr <- function(x, e = "")
  invisible(grepl(e, tryCatch(x, error = identity)[["message"]], fixed = TRUE) || stop())

nanotest(is.list(daemons()))
nanotestz(daemons()[["connections"]])
nanotestz(daemons()[["daemons"]])
n <- 3L
m <- mirai({
  Sys.sleep(0.1)
  q <- m + n + 1L
  q / m
}, m = 2L, .args = list(n), .timeout = 1000L)
b <- m$data %>>% rnorm %>>% as.character()
nanotestp(b)
nanotest(inherits(call_mirai(m), "mirai"))
nanotest(m$data == 3L || is_error_value(m$data))
nanotest(identical(call_mirai(m), m))
nanotest(is_mirai(m))
nanotest(length(b) == 3L || length(b$data) == 3L)
nanotest(is.character(b) || is.character(b$data))
Sys.sleep(2.2)
if (Sys.getenv("NOT_CRAN") == "true") {
  nanotesto(daemons(1L, dispatcher = FALSE))
  me <- mirai(mirai(), .timeout = 1000L)
  nanotest(is_mirai_error(call_mirai(me)$data) || is_error_value(me$data))
  nanotest(!is_mirai_interrupt(me$data))
  nanotest(is_error_value(me[["data"]]))
  nanotestp(me$data)
  df <- data.frame(a = 1, b = 2)
  dm <- mirai(as.matrix(df), .args = list(df), .timeout = 1000L)
  nanotest(is_mirai(call_mirai(dm)))
  nanotest(!unresolved(dm))
  nanotest(is.matrix(dm$data) || is_error_value(dm$data))
  nanotestn(stop_mirai(dm))
  nanotesto(daemons()[["connections"]])
  nanotesto(daemons()[["daemons"]])
  nanotestz(daemons(0L))
  nanotestz(daemons()[["connections"]])
  nanotestz(daemons()[["daemons"]])
  Sys.sleep(1L)
  nanotest(daemons(url = value <- sprintf(mirai:::.urlfmt, nanonext::random()), dispatcher = FALSE) == value)
  nanotestz(daemons(0L))
  Sys.sleep(0.5)
  nanotest(daemons(n = 2L, url = value <- "ws://:0", dispatcher = FALSE) != value)
  nanotestz(daemons(0L))
  Sys.sleep(0.5)
  nanotesto(daemons(url = "tcp://:0"))
  nanotestz(daemons(0L))
  Sys.sleep(1L)
  nanotesto(daemons(1L, dispatcher = FALSE, walltime = 900L, timerstart = 1L, .compute = "new"))
  mn <- mirai("test1", .compute = "new")
  mp <- mirai("test2", .compute = "new")
  nanotest(call_mirai(mn)$data == "test1" || is_error_value(mn$data))
  nanotest(call_mirai(mp)$data == "test2" || is_error_value(mp$data))
  nanotesto(daemons(.compute = "new")[["connections"]])
  Sys.sleep(2.2)
  nanotestz(daemons(.compute = "new")[["connections"]])
  nanotestz(daemons(0L, .compute = "new"))
  nanotest(daemons(n = 2, "ws://:0") == 2L)
  Sys.sleep(1.5)
  nanotest(is.matrix(status <- daemons()[["daemons"]]))
  nanotest(is.integer(attr(dn1 <- dimnames(status)[[1L]], "dispatcher_pid")))
  nanotest(is.character(parse1 <- nanonext::parse_url(dn1[1L])))
  nanotest(is.character(parse2 <- nanonext::parse_url(dn1[2L])))
  nanotest((port <- as.integer(parse1[["port"]])) > 0L)
  nanotest(as.integer(parse2[["port"]]) == port)
  nanotest(parse1[["path"]] == "/1")
  nanotest(parse2[["path"]] == "/2")
  nanotestz(sum(status[, "status_online"]))
  nanotestz(sum(status[, "status_busy"]))
  nanotestz(sum(status[, "tasks_assigned"]))
  nanotestz(sum(status[, "tasks_complete"]))
  nanotestz(sum(status[, "instance #"]))
  nanotestz(daemons(0))
  Sys.sleep(1L)
  nanotest(daemons(n = 2, "tcp://:0") == 2L)
  Sys.sleep(1.5)
  nanotest(is.matrix(status <- daemons()[["daemons"]]))
  nanotest(is.integer(attr(dn1 <- dimnames(status)[[1L]], "dispatcher_pid")))
  nanotest(is.character(parse1 <- nanonext::parse_url(dn1[1L])))
  nanotest(is.character(parse2 <- nanonext::parse_url(dn1[2L])))
  nanotest((port <- as.integer(parse1[["port"]])) > 0L)
  nanotest(as.integer(parse2[["port"]]) != port)
  nanotestz(sum(status[, "status_online"]))
  nanotestz(sum(status[, "status_busy"]))
  nanotestz(sum(status[, "tasks_assigned"]))
  nanotestz(sum(status[, "tasks_complete"]))
  nanotestz(sum(status[, "instance #"]))
  nanotestz(daemons(0))
  Sys.sleep(1L)
  cleanup <- FALSE
  nanotesto(daemons(1, dispatcher = TRUE, maxtasks = 10L, cleanup = cleanup))
  mq <- mirai("server", .timeout = 1000)
  nanotest(call_mirai(mq)$data == "server" || is_error_value(mq$data))
  nanotest(is.matrix(status <- daemons()[["daemons"]]))
  nanotesto(status[, "status_online"])
  nanotesto(status[, "instance #"])
  nanotestz(daemons(0))
  Sys.sleep(1L)
}
Sys.sleep(1L)
nanotesterr(daemons(url = "URL"), "argument")
nanotesterr(daemons(-1), "zero or greater")
nanotesterr(daemons(raw(0L)), "must be numeric")
nanotesterr(server("URL"), "argument")
nanotestz(daemons(0L))
nanotest(is_mirai_interrupt(r <- mirai:::mk_interrupt_error()))
nanotestp(r)
nanotestp(m)
nanotestp(b)

