# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test basic functionality
test_that("export_nest basic functionality works", {
  # Create sample nested data
  dt <- data.table(
    group = c("A", "B"),
    name = c("test1", "test2"),
    data = list(
      data.table(x = 1:3, y = letters[1:3]),
      data.table(x = 4:6, y = letters[4:6])
    )
  )
  
  # Create temporary directory for testing
  temp_dir <- file.path(tempdir(), "export_test")
  
  # Test basic export
  file_count <- export_nest(dt, 
                            group_cols = c("group", "name"), 
                            nest_col = "data",
                            export_path = temp_dir)
  
  # Check return value
  expect_equal(file_count, 2)
  
  # Check if files were created
  expect_true(dir.exists(file.path(temp_dir, "A", "test1")))
  expect_true(dir.exists(file.path(temp_dir, "B", "test2")))
  expect_true(file.exists(file.path(temp_dir, "A", "test1", "data.txt")))
  expect_true(file.exists(file.path(temp_dir, "B", "test2", "data.txt")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test file type handling
test_that("export_nest handles different file types", {
  dt <- data.table(
    group = "A",
    data = list(data.table(x = 1:3))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_types")
  
  # Test txt export
  export_nest(dt, file_type = "txt", export_path = temp_dir)
  expect_true(file.exists(file.path(temp_dir, "A", "data.txt")))
  
  # Test csv export
  export_nest(dt, file_type = "csv", export_path = temp_dir)
  expect_true(file.exists(file.path(temp_dir, "A", "data.csv")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test automatic group_cols detection handling
test_that("export_nest handles automatic group_cols detection", {
  dt <- data.table(
    group = "A",
    name = "test",
    data = list(data.table(x = 1:3))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_auto")
  
  # Test without specifying group_cols
  expect_message(
    export_nest(dt, nest_col = "data", export_path = temp_dir),
    "Using all non-nested columns as groups"
  )
  
  expect_true(dir.exists(file.path(temp_dir, "A", "test")))
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test automatic nest_col detection handling
test_that("export_nest handles automatic nest_col detection", {
  dt <- data.table(
    group = "A",
    data = list(data.table(x = 1:3))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_auto_nest")
  
  # Test without specifying nest_col
  expect_message(
    export_nest(dt, export_path = temp_dir),
    "Using first nested data.frame/data.table column"
  )
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test error handling
test_that("export_nest handles errors appropriately", {
  # Test empty input
  expect_error(
    export_nest(data.table()),
    "The input nest_dt cannot be empty"
  )
  
  # Test no nested columns
  expect_error(
    export_nest(data.table(a = 1)),
    "The input nest_dt must contain at least one nested column"
  )
  
  # Test invalid nest_col
  dt <- data.table(
    group = "A",
    data = list(data.table(x = 1:3))
  )
  expect_error(
    export_nest(dt, nest_col = "invalid"),
    "Specified nest_col is not a valid nested column"
  )
  
  # Test invalid file_type
  expect_error(
    export_nest(dt, file_type = "invalid"),
    "file_type must be either 'txt' or 'csv'"
  )
  
  # Test invalid group_cols
  expect_error(
    export_nest(dt, group_cols = "invalid"),
    "The following group columns are missing: invalid"
  )
})

# Test complex nested structures handling
test_that("export_nest handles complex nested structures", {
  # Create nested data with mixed types
  dt <- data.table(
    group = c("A", "B"),
    list_col = list(
      list(x = 1, y = "a"),
      list(x = 2, y = "b")
    ),
    df_col = list(
      data.frame(x = 1:2, y = letters[1:2]),
      data.frame(x = 3:4, y = letters[3:4])
    )
  )
  
  temp_dir <- file.path(tempdir(), "export_test_complex")
  
  # Test export with list column
  expect_message(
    export_nest(dt, nest_col = "list_col", export_path = temp_dir),
    "Using all non-nested columns as groups"
  )
  
  # Test export with data.frame column
  expect_message(
    export_nest(dt, nest_col = "df_col", export_path = temp_dir),
    "Using all non-nested columns as groups"
  )
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})

# Test warn handling
test_that("export_nest warns about unused columns", {
  dt <- data.table(
    group1 = "A",
    group2 = "B",
    unused = "C",
    data = list(data.table(x = 1:3))
  )
  
  temp_dir <- file.path(tempdir(), "export_test_warning")
  
  # Test warning about unused columns
  expect_warning(
    export_nest(dt, group_cols = c("group1", "group2"), export_path = temp_dir),
    "Not all non-nested columns are used as group columns"
  )
  
  # Clean up
  unlink(temp_dir, recursive = TRUE)
})
