% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeRepo.R
\name{makeRepo}
\alias{makeRepo}
\alias{updateRepoIndex}
\title{Downloads packages from CRAN to specified path and creates a local repository.}
\usage{
makeRepo(pkgs, path, repos = getOption("repos"), type = "source",
  Rversion = R.version, download = TRUE, writePACKAGES = TRUE,
  quiet = FALSE)

updateRepoIndex(path, type = "source", Rversion = R.version)
}
\arguments{
\item{pkgs}{Character vector of packages to download}

\item{path}{Destination download path. This path is the root folder of your new repository.}

\item{repos}{URL(s) of the 'contrib' sections of the repositories, e.g. \code{"http://cran.us.r-project.org"}. Passed to \code{\link[=available.packages]{available.packages()}}}

\item{type}{Possible values are (currently) "source", "mac.binary" and "win.binary": the binary types can be listed and downloaded but not installed on other platforms.  Passed to \code{\link[=download.packages]{download.packages()}}.}

\item{Rversion}{List with two named elements: \code{major} and \code{minor}. If not supplied, defaults to system version of R, using \link{R.version}.  Only used if \code{type} is not "source"}

\item{download}{If TRUE downloads packages.}

\item{writePACKAGES}{If TRUE, calls \code{\link[=write_PACKAGES]{write_PACKAGES()}} to update the repository PACKAGES file.}

\item{quiet}{If TRUE, suppress status messages (if any), and the progress bar during download.}
}
\description{
Given a list of packages, downloads these packages to a specified destination folder using the required CRAN folder structure, and finally creates the PACKAGES index file.  Since the folder structure mimics the required structure and files of a CRAN repository, it supports functions like \code{\link[utils:install.packages]{utils::install.packages()}}.
}
\note{
Internally makes use of \code{\link[utils:download.packages]{utils::download.packages()}} and \code{\link[=write_PACKAGES]{write_PACKAGES()}}
}
\section{Repo folder structure}{

The folder structure of a repository
\itemize{
\item{Root}
\itemize{
\item{src/contrib}
\itemize{
\item{PACKAGES}
}
\item{bin}
\itemize{
\item{windows/contrib/version}
\itemize{
\item{PACKAGES}
}
\item{macosx/contrib/version}
\itemize{
\item{PACKAGES}
}
\item{macosx/mavericks/contrib/version}
\itemize{
\item{PACKAGES}
}
\item{macosx/leopard/contrib/version}
\itemize{
\item{PACKAGES}
}
}
}
}
}

\examples{

# Specify list of packages to download
revolution <- c(CRAN = getOption("minicran.mran"))
pkgs <- c("foreach")

pdb <- cranJuly2014

\dontrun{
  pdb <- pkgAvail(
    repos = c(CRAN = getOption("minicran.mran")),
    type = "source"
  )
}

pkgList <- pkgDep(pkgs, availPkgs = pdb, repos = revolution, type = "source", suggests = FALSE)
pkgList


\dontrun{
# Create temporary folder for miniCRAN
dir.create(pth <- file.path(tempdir(), "miniCRAN"))

# Make repo for source and win.binary
makeRepo(pkgList, path = pth, repos = revolution, type = "source")

# List all files in miniCRAN
list.files(pth, recursive = TRUE)

# Check for available packages
pkgAvail(repos = pth, type = "source")

# Repeat process for windows binaries
makeRepo(pkgList, path = pth, repos = revolution, type = "win.binary")
pkgAvail(repos = pth, type = "win.binary")

# Delete temporary folder
unlink(pth, recursive = TRUE)
}
}
\seealso{
Other update repo functions: \code{\link{addOldPackage}},
  \code{\link{addPackage}}, \code{\link{checkVersions}},
  \code{\link{updatePackages}}
}
