% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autographr.R
\name{autographr}
\alias{autographr}
\title{Quickly graph networks with sensible defaults}
\usage{
autographr(
  object,
  algorithm = "stress",
  labels = TRUE,
  node_size = NULL,
  node_color = NULL,
  node_group = NULL,
  ...
)
}
\arguments{
\item{object}{migraph-consistent object}

\item{algorithm}{an igraph layout algorithm,
currently defaults to 'stress'
but Fruchterman-Reingold and Kamada-Kawai also available}

\item{labels}{logical, whether to print node names
as labels if present}

\item{node_size}{an override in case this
needs to be manually set}

\item{node_color}{node variable in quotation marks
that should be used for colouring the nodes}

\item{node_group}{node variable in quotation marks
that should be used for drawing convex but also concave hulls
around clusters of nodes.
These groupings will be labelled with the categories of the variable passed.}

\item{...}{extra arguments}
}
\description{
The aim of this function is to provide users with a quick and easy
graphing function that makes best use of the data,
whatever its composition.
}
\examples{
autographr(ison_coleman)
autographr(ison_karateka)
}
