% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FiltorSurrogateTournament.R
\name{dict_filtors_surtour}
\alias{dict_filtors_surtour}
\alias{FiltorSurrogateTournament}
\title{Tournament Surrogate Model Filtering}
\description{
Performs tournament surrogate model filtering. A surrogate model is used, as described in the parent class \code{\link{FiltorSurrogate}}.
}
\section{Algorithm}{

Selects individuals from a tournament by taking the top \code{per_tournament} individuals, according to \code{surrogate_selector} and
as predicted by \code{surrogate_learner}, from a sample of \code{tournament_size(i)}, where \code{tournament_size(1)} is given by
\code{tournament_size}, \code{tournament_size(ceiling(n_filter / per_tournament))} is given by \code{tournament_size_last}, and
\code{tournament_size(i)} for \code{i} between these values is linearly interpolated on a log scale.
}

\section{Configuration Parameters}{

\code{FiltorSurrogateProgressive}'s configuration parameters are the hyperparameters of the \code{\link{FiltorSurrogate}} base class, as well as:
\itemize{
\item \code{filter.per_tournament} :: \code{integer(1)}\cr
Number of individuals to select from each tournament. If \code{per_tournament} is not a divider of \code{n_filter}, then
the last tournament selects a random subset of \code{n_filter \%\% per_tournament} individuals out of the top \code{per_tournament} individuals.
Initialized to 1.
\item \code{filter.tournament_size} :: \code{numeric(1)}\cr
Tournament size used for filtering. If \code{tournament_size_last} is not given, all \code{n_filter} individuals are selected
in batches of \code{per_tournament} from tournaments of this size. If it is given, then the actual tournament size is interpolated
between \code{tournament_size} and \code{tournament_size_last} on a logarithmic scale.
Tournaments with tournament size below \code{per_tournament} select \code{per_tournament} individuals without tournament, i.e. no filtering.
Initialized to 1.
\item \code{filter.tournament_size_last} :: \code{numeric(1)}\cr
Tournament size used for the last tournament, see description of \code{tournament_size}. Defaults to \code{tournament_size} when not given,
i.e. all tournaments have the same size.
}
}

\section{Supported Operand Types}{

See \code{\link{FiltorSurrogate}} about supported operand types.
}

\section{Dictionary}{

This \code{\link{Filtor}} can be created with the short access form \code{\link[=ftr]{ftr()}}
(\code{\link[=ftrs]{ftrs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_filtors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
ftr("surtour", <surrogate_learner> [, <surrogate_selector>])
ftrs("surtour", <surrogate_learner> [, <surrogate_selector>])  # takes vector IDs, returns list of Filtors

# long form:
dict_filtors$get("surtour", <surrogate_learner> [, <surrogate_selector>])
}\if{html}{\out{</div>}}
}

\examples{
library("mlr3")
library("mlr3learners")
fp = ftr("surtour", lrn("regr.lm"), filter.tournament_size = 2)

p = ps(x = p_dbl(-5, 5))
known_data = data.frame(x = 1:5)
fitnesses = 1:5
new_data = data.frame(x = c(2.5, 4.5))

fp$prime(p)

fp$needed_input(1)

fp$operate(new_data, known_data, fitnesses, 1)

}
\seealso{
Other filtors: 
\code{\link{FiltorSurrogate}},
\code{\link{Filtor}},
\code{\link{dict_filtors_maybe}},
\code{\link{dict_filtors_null}},
\code{\link{dict_filtors_proxy}},
\code{\link{dict_filtors_surprog}}
}
\concept{filtors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Filtor]{miesmuschel::Filtor}} -> \code{\link[miesmuschel:FiltorSurrogate]{miesmuschel::FiltorSurrogate}} -> \code{FiltorSurrogateTournament}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FiltorSurrogateTournament-new}{\code{FiltorSurrogateTournament$new()}}
\item \href{#method-FiltorSurrogateTournament-clone}{\code{FiltorSurrogateTournament$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="Filtor" data-id="needed_input"><a href='../../miesmuschel/html/Filtor.html#method-Filtor-needed_input'><code>miesmuschel::Filtor$needed_input()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="FiltorSurrogate" data-id="prime"><a href='../../miesmuschel/html/FiltorSurrogate.html#method-FiltorSurrogate-prime'><code>miesmuschel::FiltorSurrogate$prime()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorSurrogateTournament-new"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorSurrogateTournament-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{FiltorSurrogateTournament}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorSurrogateTournament$new(
  surrogate_learner,
  surrogate_selector = SelectorBest$new()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{surrogate_learner}}{(\code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}})\cr
Regression learner for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_learner} field will reflect this value.}

\item{\code{surrogate_learner}}{(\code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}})\cr
Regression learner for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_learner} field will reflect this value.}

\item{\code{surrogate_selector}}{(\code{\link{Selector}})
\code{\link{Selector}} for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_selector} field will reflect this value.}

\item{\code{surrogate_selector}}{(\code{\link{Selector}})
\code{\link{Selector}} for the surrogate model filtering algorithm.\cr
The \verb{$surrogate_selector} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FiltorSurrogateTournament-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FiltorSurrogateTournament-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FiltorSurrogateTournament$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
