% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmid_mid_importance.R
\name{ggmid.mid.importance}
\alias{ggmid.mid.importance}
\alias{autoplot.mid.importance}
\title{Plot MID Importance with ggplot2}
\usage{
\method{ggmid}{mid.importance}(
  object,
  type = c("barplot", "dotchart", "heatmap", "boxplot"),
  theme = NULL,
  max.nterms = 30L,
  ...
)

\method{autoplot}{mid.importance}(object, ...)
}
\arguments{
\item{object}{a "mid.importance" object to be visualized.}

\item{type}{the plotting style. One of "barplot", "dotchart", "heatmap", or "boxplot".}

\item{theme}{a character string or object defining the color theme. See \code{\link{color.theme}} for details.}

\item{max.nterms}{the maximum number of terms to display in the bar, dot and box plots.}

\item{...}{optional parameters passed on to the main layer.}
}
\value{
\code{ggmid.mid.importance()} returns a "ggplot" object.
}
\description{
For "mid.importance" objects, \code{ggmid()} visualizes the importance of component functions of the fitted MID model.
}
\details{
This is an S3 method for the \code{ggmid()} generic that creates an importance plot from a "mid.importance" object, visualizing the average contribution of component functions to the fitted MID model.

The \code{type} argument controls the visualization style.
The default, \code{type = "barplot"}, creates a standard bar plot where the length of each bar represents the overall importance of the term.
The \code{type = "dotchart"} option creates a dot plot, offering a clean alternative to the bar plot for visualizing term importance.
The \code{type = "heatmap"} option creates a matrix-shaped heat map where the color of each cell represents the importance of the interaction between a pair of variables, or the main effect on the diagonal.
The \code{type = "boxplot"} option creates a box plot where each box shows the distribution of a term's contributions across all observations, providing insight into the variability of each term's effect.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4)
mid <- interpret(price ~ (carat + cut + color + clarity)^2, diamonds[idx, ])
imp <- mid.importance(mid)

# Create a bar plot (default)
ggmid(imp)

# Create a dot chart
ggmid(imp, type = "dotchart", theme = "Okabe-Ito", size = 3)

# Create a heatmap
ggmid(imp, type = "heatmap")

# Create a boxplot to see the distribution of effects
ggmid(imp, type = "boxplot")
}
\seealso{
\code{\link{mid.importance}}, \code{\link{ggmid}}, \code{\link{plot.mid.importance}}
}
