% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmid_mid_breakdown.R
\name{ggmid.mid.breakdown}
\alias{ggmid.mid.breakdown}
\alias{autoplot.mid.breakdown}
\title{Plot MID Breakdowns with ggplot2}
\usage{
\method{ggmid}{mid.breakdown}(
  object,
  type = c("waterfall", "barplot", "dotchart"),
  theme = NULL,
  terms = NULL,
  max.nterms = 15L,
  width = NULL,
  vline = TRUE,
  catchall = "others",
  format = c("\%t=\%v", "\%t"),
  ...
)

\method{autoplot}{mid.breakdown}(object, ...)
}
\arguments{
\item{object}{a "mid.breakdown" object to be visualized.}

\item{type}{the plotting style. One of "waterfall", "barplot" or "dotchart".}

\item{theme}{a character string or object defining the color theme. See \code{\link{color.theme}} for details.}

\item{terms}{an optional character vector specifying which terms to display.}

\item{max.nterms}{the maximum number of terms to display in the plot. Less important terms will be grouped into a "catchall" category.}

\item{width}{a numeric value specifying the width of the bars.}

\item{vline}{logical. If \code{TRUE}, a vertical line is drawn at the zero or intercept line.}

\item{catchall}{a character string for the catchall label.}

\item{format}{a character string or character vector of length two to be used as the format of the axis labels. Use "\%t" for the term name (e.g., "Wind") and "\%v" for the values (e.g., "30").}

\item{...}{optional parameters passed on to the main layer.}
}
\value{
\code{ggmid.mid.breakdown()} returns a "ggplot" object.
}
\description{
For "mid.breakdown" objects, \code{ggmid()} visualizes the breakdown of a prediction by component functions.
}
\details{
This is an S3 method for the \code{ggmid()} generic that creates a breakdown plot from a "mid.breakdown" object, visualizing the contribution of each component function to a single prediction.

The \code{type} argument controls the visualization style.
The default, \code{type = "waterfall"} (default), creates a waterfall plot that shows how the prediction is built up from the intercept, with each term's contribution sequentially added or subtracted.
The \code{type = "barplot"} option creates a standard bar plot where the length of each bar represents the magnitude of the term's contribution.
The \code{type = "dotchart"} option creates a dot plot showing the contribution of each term as a point connected to a zero baseline.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4)
mid <- interpret(price ~ (carat + cut + color + clarity)^2, diamonds[idx, ])
mbd <- mid.breakdown(mid, diamonds[1L, ])

# Create a waterfall plot
ggmid(mbd, type = "waterfall")

# Create a bar plot with a different theme
ggmid(mbd, type = "barplot", theme = "highlight")

# Create a dot chart
ggmid(mbd, type = "dotchart", size = 3)
}
\seealso{
\code{\link{mid.breakdown}}, \code{\link{ggmid}}, \code{\link{plot.mid.breakdown}}
}
