# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computes cross-validation folds. 
#' 
#' @param nfolds (double) number of folds.
#' @param nrow (double) number of rows of data. 
#' @return foldsid (vec) vector of cv folds.
#' @export cvfolds
#' @keywords internal
cvfolds <- function(nfolds, nrow) {
    .Call(`_midasml_cvfolds`, nfolds, nrow)
}

#' Computes optimal \eqn{\lambda} for cross-validation output.
#' 
#' @param lambda (vec) vector of \eqn{\lambda} parameters.
#' @param cvm (vec) vector of cv error curve. 
#' @param cvsd (vec) vector of standard errors for cv error curve.
#' @param which_lambda which optimal \eqn{\lambda} to select; 0 - min of cv error curve, 1 - 1se min of cv error curve.
#' @export getmin_cpp
#' @keywords internal
getmin_cpp <- function(lambda, cvm, cvsd, which_lambda) {
    .Call(`_midasml_getmin_cpp`, lambda, cvm, cvsd, which_lambda)
}

#' Computes a single solution for \eqn{\lambda_1} and \eqn{\lambda_2} values
#' 
#' @param beta0 (vec) vector of initial \eqn{\beta_0} regression coefficients.
#' @param Z (mat) matrix of dummies. 
#' @param X (mat) matrix of covariates.
#' @param y (vec) vector of response.
#' @param index (vec) vector indicating group membership of each covariate.
#' @param lambda1 (vec) single value of \eqn{\lambda_1}.
#' @param lambda2 (vec) single value of \eqn{\lambda_2}.
#' @param innerIter (int) max number of inner iterations.
#' @param outerIter (int) max number of outer iterations.
#' @param thresh (double) convergence threshold of inner loop.
#' @param outerThresh (double) convergence threshold of outer loop.
#' @param gamma_solver (double) solver parameter.
#' @param step (double) solver parameter.
#' @param reset (int) solver parameter.
#' @export cpp_sgl_fit
#' @keywords internal
cpp_sgl_fit <- function(beta0, Z, X, y, index, lambda1, lambda2, innerIter, outerIter, thresh, outerThresh, gamma_solver, step, reset) {
    .Call(`_midasml_cpp_sgl_fit`, beta0, Z, X, y, index, lambda1, lambda2, innerIter, outerIter, thresh, outerThresh, gamma_solver, step, reset)
}

#' Computes a path solution for \eqn{\lambda} and fixed \eqn{\gamma} values
#' 
#' @param X (mat) matrix of covariates.
#' @param Z (mat) matrix of dummies. 
#' @param y (vec) vector of response.
#' @param index (vec) vector indicating group membership of each covariate.
#' @param dummies (double) add dummy variables in a regression (dummies = 1) or not (dummies = 0).
#' @param l1_frac \eqn{\ell_1} norm peanlty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_1 norm}).
#' @param l21_frac \eqn{\ell_{1,2}} norm peanlty factor for random or fixed effects (default value is zero which means \eqn{\alpha} is left unpenalized in \eqn{\ell_{1,2}} norm).
#' @param dummies_index vector indicating group membership of \eqn{\alpha}.
#' @param lambdas (vec) sequence of \eqn{\lambda} values for fitting.
#' @param gamma_w (double) sg-LASSO mixing parameter.
#' @param innerIter (int) max number of inner iterations.
#' @param outerIter (int) max number of outer iterations.
#' @param thresh (double) convergence threshold of inner loop.
#' @param outerThresh (double) convergence threshold of outer loop.
#' @param gamma_solver (double) solver parameter.
#' @param step (double) solver parameter.
#' @param reset (int) solver parameter.
#' @export cpp_sgl_fitpath
#' @keywords internal
cpp_sgl_fitpath <- function(X, Z, y, index, dummies, l1_frac, l21_frac, dummies_index, lambdas, gamma_w, innerIter, outerIter, thresh, outerThresh, gamma_solver, step, reset) {
    .Call(`_midasml_cpp_sgl_fitpath`, X, Z, y, index, dummies, l1_frac, l21_frac, dummies_index, lambdas, gamma_w, innerIter, outerIter, thresh, outerThresh, gamma_solver, step, reset)
}

#' Computes fast OLS solution
#' 
#' @param Y (vec) vector of response.
#' @param X (mat) matrix of covariates.
#' @param intercept (double) 1 - includes intercept, else not.
#' @export fastols
#' @keywords internal
fastols <- function(Y, X, intercept) {
    .Call(`_midasml_fastols`, Y, X, intercept)
}

#' Computes fast ALS solution
#' 
#' @param Y (vec) vector of response.
#' @param X (mat) matrix of covariates.
#' @param intercept (double) 1 - includes intercept, else not.
#' @param tau (double) quantile level.
#' @param maxIter maximum number of iterations.
#' @param thresh threshold value for stopping criterion.
#' @export fastals
#' @keywords internal
fastals <- function(Y, X, intercept, tau, maxIter, thresh) {
    .Call(`_midasml_fastals`, Y, X, intercept, tau, maxIter, thresh)
}

#' Computes fast rq solution
#' 
#' @param Y (vec) vector of response.
#' @param X (mat) matrix of covariates.
#' @param intercept (double) 1 - includes intercept, else not.
#' @param tau (double) quantile level.
#' @export fastrq
#' @keywords internal
fastrq <- function(Y, X, intercept, tau) {
    .Call(`_midasml_fastrq`, Y, X, intercept, tau)
}

#' Computes fast DL-MIDAS profiling solution
#' 
#' @param Y (vec) vector of response.
#' @param X (mat) matrix of covariates.
#' @param intercept (double) 1 - includes intercept, else not.
#' @param tau (double) quantile level.
#' @param which_loss loss function choice. 1 - mse, 2 - als, 3 - rq.
#' @param num_evals number of evalution points of MIDAS parameter.
#' @export midas_pr
#' @keywords internal
midas_pr <- function(Y, X, intercept, tau, which_loss, num_evals) {
    .Call(`_midasml_midas_pr`, Y, X, intercept, tau, which_loss, num_evals)
}

#' Computes fast ARDL-MIDAS profiling solution
#' 
#' @param Y (vec) vector of response.
#' @param YLAG (mat) matrix of lagged values of Y.
#' @param X (mat) matrix of covariates.
#' @param intercept (double) 1 - includes intercept, else not.
#' @param tau (double) quantile level.
#' @param which_loss loss function choice. 1 - mse, 2 - als, 3 - rq.
#' @param num_evals number of evalution points of MIDAS parameter.
#' @export midasar_pr
#' @keywords internal
midasar_pr <- function(Y, YLAG, X, intercept, tau, which_loss, num_evals) {
    .Call(`_midasml_midasar_pr`, Y, YLAG, X, intercept, tau, which_loss, num_evals)
}

