% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{micsr}
\alias{micsr}
\alias{llobs}
\alias{coef.micsr}
\alias{vcov.micsr}
\alias{summary.micsr}
\alias{coef.summary.micsr}
\alias{print.micsr}
\alias{print.summary.micsr}
\alias{logLik.micsr}
\alias{BIC.micsr}
\alias{AIC.micsr}
\alias{deviance.micsr}
\alias{predict.micsr}
\alias{model.part.micsr}
\alias{model.matrix.micsr}
\alias{estfun.micsr}
\alias{vcovHC.micsr}
\alias{bread.micsr}
\alias{nobs.micsr}
\alias{llobs.micsr}
\alias{llobs.mlogit}
\alias{tidy.micsr}
\alias{glance.micsr}
\title{\code{micsr} class}
\usage{
llobs(x, ...)

\method{coef}{micsr}(object, ..., subset = NA)

\method{vcov}{micsr}(object, ..., vcov = c("info", "hessian", "opg"), subset = NA)

\method{summary}{micsr}(object, ..., vcov = c("hessian", "info", "opg"), subset = NA)

\method{coef}{summary.micsr}(object, ...)

\method{print}{micsr}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{print}{summary.micsr}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)

\method{logLik}{micsr}(object, ..., type = c("model", "null", "saturated"))

\method{BIC}{micsr}(object, ..., type = c("model", "null"))

\method{AIC}{micsr}(object, ..., k = 2, type = c("model", "null"))

\method{deviance}{micsr}(object, ..., type = c("model", "null"))

\method{predict}{micsr}(object, ..., newdata = NULL)

\method{model.part}{micsr}(object, ..., lhs = 1)

\method{model.matrix}{micsr}(object, formula = NULL, ..., rhs = 1)

\method{estfun}{micsr}(x, ...)

\method{vcovHC}{micsr}(x, type, omega = NULL, sandwich = TRUE, ...)

\method{bread}{micsr}(x, ...)

\method{nobs}{micsr}(object, ...)

\method{llobs}{micsr}(x, ...)

\method{llobs}{mlogit}(x, ...)

\method{tidy}{micsr}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{glance}{micsr}(x, ...)
}
\arguments{
\item{x, object}{an object which inherits the \code{micsr} class}

\item{...}{further arguments}

\item{subset}{a character which indicates which subset of
coefficients should be extracted: one of \code{noinst} (all the
coefficients except those corresponding to instrumental
variables), \code{all}, \code{covar} (only the coefficients of the
covariates), \code{inst} (only the coefficients of the instrumental
variables) and \code{misc} (ony the "miscelanous" coefficients,
typicaly a standard deviation or a coefficient of correlation)}

\item{vcov}{the method used to compute the covariance matrix of the
estimators (only for the ML estimator), one of \code{hessian} (the
opposite of the inverse of the hessian), \code{info} (the inverse of
the opposite of the expected value of the hessian), \code{opg} (the
outer product of the gradient)}

\item{digits, width}{see \code{print}}

\item{type, omega, sandwich}{see \code{sandwich::sandwich}}

\item{k}{see \code{AIC}}

\item{newdata}{a new data frame to compute the predictions}

\item{lhs, rhs}{see \code{Formula::model.frame.Formula}}

\item{formula}{a formula}

\item{conf.int, conf.level}{see \code{broom:tidy.lm}}
}
\value{
Objects of class \code{micsr} share a lot of common elements with \code{lm}:
\code{coefficients}, \code{residuals}, \code{fitted.values}, \code{model}, \code{terms},
\code{df.residual}, \code{xlevels}, \code{na.action}, and \code{call}. \code{npar} is a
named vector containing the index of subset of coefficients, it is
used to print a subset of the results.  It also has a \code{est_method}
element and, depending of its value, contains further elements. In
particular, for model fitted by maximum likelihood, \code{value}
contains the individual contribution to the log-likelihood
function, \code{gradient} the individual contribution to the gradient,
\code{hessian} the hessian and \code{information} the information
matrix. \code{logLik} contains the log-likelihood values of the
proposed, null and saturated models. \code{tests} contains the values of
the test that all the coefficients of the covariates are 0, using
the three classical tests.

The \code{llobs} function is provided as a generic to extract the
individual contributions to the log-likelihood

Specific methods have been writen for \code{micsr} objects: \code{nobs},
\code{generics::tidy}, \code{generics::glance}, \code{sandwich::meat},
\code{sandwich::estfun}, \code{predict}, \code{model.matrix},
\code{Formula::model.part}.

\code{logLik}, \code{BIC}, \code{AIC} and \code{deviance} methods have a \code{type}
argument to select theproposed, null or saturated model.

\code{vcov} and \code{summary} methods have a \code{vcov} argument to select the
estimator of the covariance matrix, which can be either based on
the hessian, the gradient or the information.

\code{vcov}, \code{summary} and \code{coef} have a subset argument to select only
a subset of the coefficients
}
\description{
The \code{micsr} class is intend to deal with a lot of different models
that are estimated in the \code{micsr} package. More specifically, some
models may be estimated using different estimation methods, like
maximum likelihood, GMM or two-steps estimators. Objects of class
\code{micsr} have an \code{est_method} item which is used by the different
methods in order to have a relevent behaviour for the different
methods.
}
