% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entrez.R
\name{getAccessions}
\alias{getAccessions}
\title{Collecting contig accession numbers}
\usage{
getAccessions(master.record.accession, chunk.size = 99)
}
\arguments{
\item{master.record.accession}{The accession number (single text) to a master record GenBank file having
the WGS entry specifying the accession numbers to all contigs of the WGS genome.}

\item{chunk.size}{The maximum number of accession numbers returned in one text.}
}
\value{
A character vector where each element is a text listing the accession numbers separated by comma.
Each vector element will contain no more than \code{chunk.size} accession numbers, see 
\code{\link{entrezDownload}} for details on this. The vector returned by \code{\link{getAccessions}}
is typically used as input to \code{\link{entrezDownload}}.
}
\description{
Retrieving the accession numbers for all contigs from a master record GenBank file.
}
\details{
In order to download a WGS genome (draft genome) using \code{\link{entrezDownload}} you will
need the accession number of every contig. This is found in the master record GenBank file, which is
available for every WGS genome. \code{\link{getAccessions}} will extract these from the GenBank file and
return them in the apropriate way to be used by \code{\link{entrezDownload}}.

The download API at NCBI will not tolerate too many accessions per query, and for this reason you need
to split the accessions for many contigs into several texts using \code{chunk.size}.
}
\examples{
\dontrun{
# The master record accession for the WGS genome Mycoplasma genitalium, strain G37
acc <- getAccessions("AAGX00000000")
# Then we use this to download all contigs and save them
genome.file <- tempfile(fileext = ".fna")
txt <- entrezDownload(acc, out.file = genome.file)

# ...cleaning...
ok <- file.remove(genome.file)
}

}
\seealso{
\code{\link{entrezDownload}}.
}
\author{
Lars Snipen and Kristian Liland.
}
