% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_nullmodel.R
\name{trans_nullmodel}
\alias{trans_nullmodel}
\title{Create trans_nullmodel object.}
\description{
This class is a wrapper for a series of null model and phylogeny related approaches, including the mantel correlogram analysis of phylogenetic signal, betaNTI, betaNRI and RCbray calculations;
see Stegen et al. (2013) <10.1038/ismej.2013.93> and Liu et al. (2017) <doi:10.1038/s41598-017-17736-w>.
}
\examples{

## ------------------------------------------------
## Method `trans_nullmodel$new`
## ------------------------------------------------

data(dataset)
data(env_data_16S)
t1 <- trans_nullmodel$new(dataset, taxa_number = 100, add_data = env_data_16S)

## ------------------------------------------------
## Method `trans_nullmodel$cal_mantel_corr`
## ------------------------------------------------

\donttest{
t1$cal_mantel_corr(use_env = "pH")
}

## ------------------------------------------------
## Method `trans_nullmodel$plot_mantel_corr`
## ------------------------------------------------

\donttest{
t1$plot_mantel_corr()
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_betampd`
## ------------------------------------------------

\donttest{
t1$cal_betampd(abundance.weighted=FALSE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_betamntd`
## ------------------------------------------------

\donttest{
t1$cal_betamntd(abundance.weighted=FALSE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_ses_betampd`
## ------------------------------------------------

\donttest{
t1$cal_ses_betampd(runs = 100, abundance.weighted = FALSE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_ses_betamntd`
## ------------------------------------------------

\donttest{
t1$cal_ses_betamntd(runs = 100, abundance.weighted = FALSE, exclude.conspecifics = FALSE)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_rcbray`
## ------------------------------------------------

\donttest{
t1$cal_rcbray(runs=200)
}

## ------------------------------------------------
## Method `trans_nullmodel$cal_process`
## ------------------------------------------------

\donttest{
t1$cal_process(use_betamntd = TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_nullmodel$new()}}
\item \href{#method-cal_mantel_corr}{\code{trans_nullmodel$cal_mantel_corr()}}
\item \href{#method-plot_mantel_corr}{\code{trans_nullmodel$plot_mantel_corr()}}
\item \href{#method-cal_betampd}{\code{trans_nullmodel$cal_betampd()}}
\item \href{#method-cal_betamntd}{\code{trans_nullmodel$cal_betamntd()}}
\item \href{#method-cal_ses_betampd}{\code{trans_nullmodel$cal_ses_betampd()}}
\item \href{#method-cal_ses_betamntd}{\code{trans_nullmodel$cal_ses_betamntd()}}
\item \href{#method-cal_rcbray}{\code{trans_nullmodel$cal_rcbray()}}
\item \href{#method-cal_process}{\code{trans_nullmodel$cal_process()}}
\item \href{#method-clone}{\code{trans_nullmodel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$new(
  dataset = NULL,
  filter_thres = 0,
  taxa_number = NULL,
  group = NULL,
  select_group = NULL,
  env_cols = NULL,
  add_data = NULL,
  complete_na = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{filter_thres}}{default 0; the relative abundance threshold.}

\item{\code{taxa_number}}{default NULL; how many taxa you want to use, if set, filter_thres parameter invalid.}

\item{\code{group}}{default NULL; which group column name in sample_table is selected.}

\item{\code{select_group}}{default NULL; the group name, used following the group to filter samples.}

\item{\code{env_cols}}{default NULL; number or name vector to select the environmental data in dataset$sample_table.}

\item{\code{add_data}}{default NULL; provide environmental data table additionally.}

\item{\code{complete_na}}{default FALSE; whether fill the NA in environmental data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
intermediate files in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
data(env_data_16S)
t1 <- trans_nullmodel$new(dataset, taxa_number = 100, add_data = env_data_16S)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_mantel_corr"></a>}}
\if{latex}{\out{\hypertarget{method-cal_mantel_corr}{}}}
\subsection{Method \code{cal_mantel_corr()}}{
Calculate mantel correlogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_mantel_corr(
  use_env = NULL,
  break.pts = seq(0, 1, 0.02),
  cutoff = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_env}}{default NULL; numeric or character vector to select env_data; if provide multiple variables or NULL, use PCA to reduce dimensionality.}

\item{\code{break.pts}}{default seq(0, 1, 0.02); see \code{\link{mantel.correlog}}}

\item{\code{cutoff}}{default FALSE; see cutoff in \code{\link{mantel.correlog}}}

\item{\code{...}}{parameters pass to \code{\link{mantel.correlog}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_mantel_corr in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_mantel_corr(use_env = "pH")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_mantel_corr"></a>}}
\if{latex}{\out{\hypertarget{method-plot_mantel_corr}{}}}
\subsection{Method \code{plot_mantel_corr()}}{
Plot mantel correlogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$plot_mantel_corr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_mantel_corr()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_betampd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_betampd}{}}}
\subsection{Method \code{cal_betampd()}}{
Calculate betaMPD. Faster than comdist in picante package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_betampd(abundance.weighted = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abundance.weighted}}{default FALSE; whether use weighted abundance}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_betampd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_betampd(abundance.weighted=FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_betamntd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_betamntd}{}}}
\subsection{Method \code{cal_betamntd()}}{
Calculate betaMNTD. Faster than comdistnt in picante package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_betamntd(
  abundance.weighted = FALSE,
  exclude.conspecifics = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abundance.weighted}}{default FALSE; whether use weighted abundance}

\item{\code{exclude.conspecifics}}{default FALSE; see comdistnt in picante package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_betamntd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_betamntd(abundance.weighted=FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_ses_betampd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_ses_betampd}{}}}
\subsection{Method \code{cal_ses_betampd()}}{
Calculate ses.betaMPD (betaNRI).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_ses_betampd(
  runs = 1000,
  abundance.weighted = FALSE,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{runs}}{default 1000; simulation runs.}

\item{\code{abundance.weighted}}{default FALSE; whether use weighted abundance.}

\item{\code{verbose}}{default TRUE; whether show the calculation process message.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ses_betampd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ses_betampd(runs = 100, abundance.weighted = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_ses_betamntd"></a>}}
\if{latex}{\out{\hypertarget{method-cal_ses_betamntd}{}}}
\subsection{Method \code{cal_ses_betamntd()}}{
Calculate ses.betaMNTD (betaNTI).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_ses_betamntd(
  runs = 1000,
  abundance.weighted = FALSE,
  exclude.conspecifics = FALSE,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{runs}}{default 1000; simulation runs.}

\item{\code{abundance.weighted}}{default FALSE; whether use weighted abundance}

\item{\code{exclude.conspecifics}}{default FALSE; see comdistnt in picante package.}

\item{\code{verbose}}{default TRUE; whether show the calculation process message.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_ses_betamntd in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ses_betamntd(runs = 100, abundance.weighted = FALSE, exclude.conspecifics = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_rcbray"></a>}}
\if{latex}{\out{\hypertarget{method-cal_rcbray}{}}}
\subsection{Method \code{cal_rcbray()}}{
Calculate rcbray.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_rcbray(runs = 1000, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{runs}}{default 1000; simulation runs.}

\item{\code{verbose}}{default TRUE; whether show the calculation process message.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_rcbray in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_rcbray(runs=200)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_process"></a>}}
\if{latex}{\out{\hypertarget{method-cal_process}{}}}
\subsection{Method \code{cal_process()}}{
Infer the processes according to ses.betaMNTD ses.betaMPD and rcbray.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$cal_process(use_betamntd = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_betamntd}}{default TRUE; whether use ses.betaMNTD; if false, use ses.betaMPD.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_rcbray in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_process(use_betamntd = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_nullmodel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
