% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{taxonomy.table}
\alias{taxonomy.table}
\title{Taxonomy look-up table}
\usage{
data(taxonomy.table)
}
\description{
A data frame consisting of the taxonomy information used in the ConTax data sets.
}
\details{
\code{taxonomy.table} is a \code{data.frame} consisting of the seven columns Domain,
Phylum, Class, Order, Family, Genus and LPSN. The first six are taxonomy informations, the last
is "Yes" or "No" indiocating if the Genus listed is also found in the List of prokaryotic names
with standing in nomenclature (LPSN) database, see http://www.bacterio.net/.

Each row contains the taxonomy information for a genus, hence the number of rows equals the number
of unique genera.

To quickly look-up the higher-level taxonomy for a given genus, see the function \code{\link{genusLookup}}.
}
\examples{
data(taxonomy.table)
dim(taxonomy.table)
taxonomy.table[1:10,]
genusLookup(taxonomy.table$Genus[1:10],level="Family")

}
\author{
Hilde Vinje, Kristian Hovde Liland, Lars Snipen.
}
\seealso{
\code{\link{genusLookup}}, \code{\link[microcontax.data]{contax.full}},
\code{\link{contax.trim}}, \code{\link{getDomain}}.
}

