% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpoutput.R
\name{plot.cmpoutput}
\alias{plot.cmpoutput}
\title{Plot comparison of an output}
\usage{
\method{plot}{cmpoutput}(x, ...)
}
\arguments{
\item{x}{Object of class \code{cmpoutput}.}

\item{...}{Extra options passed to \code{\link[graphics]{plot.default}}. The
\code{col} option determines the colors to use on observations of different
groups (scatter plot only).}
}
\value{
None.
}
\description{
Plot objects of class \code{cmpoutput}.
}
\details{
This method produces four sub-plots, namely:
\itemize{
  \item Scatter plot containing the projection of output observations on the
        first two dimensions of the principal components space.
  \item Bar plot of the percentage of variance explain per principal
        component.
  \item Bar plot of \emph{p}-values for the parametric test for each
        principal component.
  \item Bar plot of \emph{p}-values for the non-parametric test for each
        principal component.
}
}
\examples{

# Comparing the concatenated output of the pphpc_ok dataset, which
# contains simulation output data from two similar implementations of the
# PPHPC model.

plot(cmpoutput("All", 0.95, pphpc_ok$data[["All"]], pphpc_ok$obs_lvls))

}
