% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotImputationVariance.R
\name{plotImputationVariance}
\alias{plotImputationVariance}
\title{plotImputationVariance}
\usage{
plotImputationVariance(
  miceObj,
  vars = names(miceObj$callParams$vars),
  monteCarloSimulations = 10000,
  ...
)
}
\arguments{
\item{miceObj}{an object of class miceDefs, created by the miceRanger function.}

\item{vars}{the variables you want to plot. Default is to plot all variables. Can be a vector of
variable names, or one of 'allNumeric' or 'allCategorical'}

\item{monteCarloSimulations}{The number of simulations to run to determine the distribution of
unique categorical levels drawn if the draws were completely random.}

\item{...}{additional parameters passed to \code{ggarrange}.}
}
\value{
an object of class \code{ggarrange}.
}
\description{
plots the distribution of the difference between datasets of the imputed values.
For categorical variables, the distribution of the number of distinct levels imputed for each sample
is shown next to the expected hypergeometric distribution, if the imputation was completely random.
For numeric variables, the density of the standard deviation (between datasets) of imputations is 
plotted. The shaded area represents the samples that had a standard deviation lower than the total
nonmissing standard deviation for the original data.
}
\examples{
data("sampleMiceDefs")
plotImputationVariance(sampleMiceDefs)
}
