% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_quantile_matrix_WQS.R
\name{make.quantile.matrix}
\alias{make.quantile.matrix}
\title{Accessory WQS Function: Making Quantiles of Correlated Index}
\usage{
make.quantile.matrix(x, n.quantiles, verbose = FALSE, ...)
}
\arguments{
\item{x}{A numeric matrix. Any missing values are indicated by NA's.}

\item{n.quantiles}{An integer to specify how chemicals will be ranked, e.g. in quartiles (q = 4), deciles (q = 10), or percentiles (q = 100).
Number of quantiles to be used categorizing the columns of X. Default: 4.}

\item{verbose}{Logical; if TRUE, prints more information. Useful to check for errors in
the code. Default: FALSE.}

\item{...}{Further arguments passed to or from other methods. Currently has no effect.}
}
\description{
\code{make.quantile.matrix} makes quantiles from a matrix. If the matrix has values missing between 0 and some threshold, say the detection limit, all these missing values  (indicated by NA) go into the first quantile.
}
\details{
Accessory functions for WQS. Produces sample quantiles for a matrix \emph{x} using \code{\link[stats]{quantile}} function. Names are kept and the 7th quantile algorithm is used. When there is missing data (as indicated by NA's), \code{make.quantile.matrix} places all of the censored data into the first quantile. The remaining quantiles are evenly spread over the observed data. A printed message is displaced what the function does.
}
\note{
The \code{make.quantile.matrix} is a helper function in \pkg{wqs}.
}
\examples{
#Example 1: Make quantiles for first nine chemicals using complete chemical data
data(simdata87)
q <- make.quantile.matrix( simdata87$X.true[ , 1:9], 4)
summary(q)

#Example 2: Place missing values of first nine chemicals in first quantiles
q2 <- make.quantile.matrix( simdata87$X.bdl[  , 1:9], 4, verbose = TRUE)
summary(q2)

}
\seealso{
\code{\link[stats]{quantile}}

Other wqs: \code{\link{coef.wqs}},
  \code{\link{estimate.wqs}}, \code{\link{plot.wqs}},
  \code{\link{print.wqs}}
}
\concept{wqs}
\keyword{wqs}
