% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_count.R
\name{compare_mir_count}
\alias{compare_mir_count}
\title{Compare count of miRNA names between different topics}
\usage{
compare_mir_count(
  df,
  mir,
  topic = NULL,
  normalize = TRUE,
  col.topic = Topic,
  col.mir = miRNA,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing columns for miRNA names, topics,
and PubMed-IDs.}

\item{mir}{Character vector. Vector specifying which miRNA names to
compare.}

\item{topic}{Character vector. Optional. Vector
specifying which topics to compare.}

\item{normalize}{Boolean. If \code{normalize = TRUE}, plot the proportion of
abstracts mentioning a miRNA name compared to all abstracts in a topic.
If \code{normalize = FALSE}, plot the absolute number of abstracts mentioning a miRNA
in a topic.}

\item{col.topic}{Symbol. Column containing topic names.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Bar plot comparing the count of miRNA names between different topics.
}
\description{
Compare count of miRNA names between different topics.
}
\details{
Compare count of miRNA names between different topics by plotting the number
of abstracts mentioning the miRNA in a topic. This count can either be normalized,
thus plotting the proportion of abstracts mentioning a miRNA name compared to all
abstracts of a topic, or it can be not normalized, thus plotting the absolute
number of abstracts mentioning a miRNA per topic.
}
\seealso{
\code{\link[=compare_mir_count_log2]{compare_mir_count_log2()}}, \code{\link[=compare_mir_count_unique]{compare_mir_count_unique()}}

Other compare functions: 
\code{\link{compare_mir_count_log2}()},
\code{\link{compare_mir_count_unique}()},
\code{\link{compare_mir_terms_log2}()},
\code{\link{compare_mir_terms_scatter}()},
\code{\link{compare_mir_terms_unique}()},
\code{\link{compare_mir_terms}()}
}
\concept{compare functions}
