% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/self_made_topics.R
\name{calculate_score_topic}
\alias{calculate_score_topic}
\title{Calculate scores of a self-chosen topic}
\usage{
calculate_score_topic(
  df,
  keywords,
  case = FALSE,
  col.score = "topic_score",
  col.indicate = NULL,
  threshold = NULL,
  discard = FALSE,
  col.abstract = Abstract
)
}
\arguments{
\item{df}{Data frame containing abstracts.}

\item{keywords}{Character vector. Vector containing keywords. The score is
calculated based on these keywords. How much weight a keyword in \code{keywords}
carries is determined by how often it is present in \code{keywords}, e.g. if
a keyword is mentioned twice in \code{keywords} and it is mentioned only once in
an abstract, it adds 2 points to the score.}

\item{case}{Boolean. If \code{case = TRUE}, terms contained in \code{keywords} are case
sensitive. If \code{case = FALSE}, terms contained in \code{keywords} are case insensitive.}

\item{col.score}{String. Name of \code{topic_score} column.}

\item{col.indicate}{String. Optional. Name of indicating column. If a string
is provided, an extra column is added to \code{df}, indicating if the abstract
corresponds to the topic of interest by "Yes" or "No".}

\item{threshold}{Integer. Optional. Threshold to decide if abstract
corresponds to topic of interest. If \code{col.topic} is specified or \code{discard = TRUE}
without \code{threshold} being specified, \code{threshold} is automatically set to \code{1}.}

\item{discard}{Boolean. If \code{discard = TRUE}, only abstracts are kept that
correspond to the topic of interest.}

\item{col.abstract}{Symbol. Column containing abstracts.}
}
\value{
Data frame with calculated topic scores.
If \code{discard = FALSE}, adds extra columns
to the original data frame with the calculated topic scores.
If \code{discard = TRUE}, only abstracts corresponding to
the topic of interest are kept.
}
\description{
Calculate score of a self-chosen topic for each abstract to identify
abstracts possibly corresponding to the topic of interest.
}
\details{
Calculate score of a self-chosen topic for each abstract to identify
abstracts possibly corresponding to the topic of interest.
This score is added to the data frame as an additional
column, usually called \code{topic_score}, containing the calculated topic score.
If there is more than one topic of interest, the column \code{topic_score} should
be appropriately renamed.
To decide which abstracts are considered to correspond to the topic of interest,
a threshold
can be set via the \code{threshold} argument. Furthermore, an additional
column can be added, verbally indicating if the abstract corresponds to the
topic.
Choosing the right threshold can be facilitated using \code{plot_score_topic()}.
}
\seealso{
\code{\link[=assign_topic]{assign_topic()}}, \code{\link[=plot_score_topic]{plot_score_topic()}}

Other score functions: 
\code{\link{assign_topic}()},
\code{\link{calculate_score_animals}()},
\code{\link{calculate_score_biomarker}()},
\code{\link{calculate_score_patients}()},
\code{\link{plot_score_animals}()},
\code{\link{plot_score_biomarker}()},
\code{\link{plot_score_patients}()},
\code{\link{plot_score_topic}()}
}
\concept{score functions}
