% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign_pkgs.R
\name{prediction_margins}
\alias{prediction_margins}
\alias{prediction.mhurdle}
\title{prediction methods}
\usage{
\method{prediction}{mhurdle}(
  model,
  data = find_data(model, parent.frame()),
  at = NULL,
  what = c("E", "Ep", "p"),
  vcov = stats::vcov(model),
  calculate_se = FALSE,
  ...
)
}
\arguments{
\item{model}{a model fitted using \code{mhurdle}}

\item{data, at, vcov, calculate_se}{see \code{prediction::prediction}}

\item{what}{see \code{mhurdle:::predict.mhurdle}}

\item{...}{further arguments, especially, a \code{what} argument can be
provided and will be passed to \code{predict}}
}
\description{
Methods to compute the predictions and the marginal effects for
tobit1 objects
}
\details{
\code{tobit1} exports the \code{prediction::prediction} and
\code{margins::margins} functions. \code{prediction} use the \code{predict}
method to compute the predictions in a "tidy way", it returns
the data frame provided for the predictions augmented by the
predictions. \code{margins} compute the average marginal effect of
every covariate. It uses the numerical derivatives of the
predictions using the \code{prediction} function.
}
