% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTransEqtl_function.R
\name{addTransEqtl}
\alias{addTransEqtl}
\title{Add trans eQTL data to list}
\usage{
addTransEqtl(mgl, download = T, saveDownload = F, fpsource = "./")
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{download}{A logical vector indicating if the data should be downloaded.}

\item{saveDownload}{A logical vector indicating if the data should be saved as 'RawData_transEqtls.RData'}

\item{fpsource}{A character string of with the filepath where the data has been downloaded}
}
\description{
\code{addTransEqtl} returns an 'mgl' list with the thirteenth element as a list with each element being a dataframe with trans eQTL data from GTEx for a given tissue for the gene of interest.
}
\details{
This gives basic information on tissue specific eQTLs as reported by GTEx for the gene of interest.  It pulls eQTL data based on the ENSG identifier.  Data is downloaded from GTEx \url{gtexportal.org/}.
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addTransEqtl(myMgl)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addExpression}}, \code{\link{addGo}},
  \code{\link{addGrasp}}, \code{\link{addGwasCatalog}},
  \code{\link{addLoc}}, \code{\link{addPtv}},
  \code{\link{addPubmed}}, \code{\link{addSqtlAltrans}},
  \code{\link{addSqtlSeek}}, \code{\link{missNames}}
}

