% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{posterior_Pi_Sigma}
\alias{posterior_Pi_Sigma}
\title{Draw from posterior of Pi and Sigma}
\usage{
posterior_Pi_Sigma(Z_r1, d, psi_r1, prior_Pi_mean, prior_Pi_Omega,
  inv_prior_Pi_Omega, Omega_Pi, prior_S, prior_nu, check_roots, n_vars,
  n_lags, n_T)
}
\arguments{
\item{Z_r1}{The previous draw of \code{Z} (i.e. \code{Z[,, r-1]}).}

\item{d}{The matrix of size \code{(n_T + n_lags) * n_determ} of deterministic terms.}

\item{psi_r1}{The previous draw of \code{psi} (i.e. \code{psi[r-1,]}).}

\item{prior_Pi_mean}{Matrix of size \code{n_vars * (n_vars*n_lags)} containing the prior for the mean of the dynamic coefficients.}

\item{prior_Pi_Omega}{Matrix of size \code{(n_vars*n_lags)* (n_vars*n_lags)} containing the prior for (part of) the prior covariance of the dynamic coefficients.}

\item{inv_prior_Pi_Omega}{The inverse of the prior covariance matrix for Pi.}

\item{Omega_Pi}{The \code{inv_prior_Pi_Omega} multiplied by \code{prior_Pi} matrix.}

\item{prior_S}{The prior for \eqn{\Sigma}.}

\item{prior_nu}{The prior degrees of freedom.}

\item{check_roots}{Logical, if roots of the companion matrix are to be checked to ensure stationarity.}

\item{n_vars}{The number of variables.}

\item{n_lags}{The number of lags.}

\item{n_T}{The number of time points.}
}
\value{
\code{posterior_Pi_Sigma} returns a list with:
\item{Pi_r}{The draw of \code{Pi}.}
\item{Sigma_r}{The draw of \code{Sigma}.}
\item{num_try}{The try at which a stable draw was obtained.}
\item{root}{The maximum eigenvalue (in modulus) of the system.}
}
\description{
Function for drawing from the posterior of Pi and Sigma, which can be used as a block in a Gibbs sampler.
}
\keyword{internal}
